/* $Id: map_chars.cc,v 1.2 1997/03/23 13:19:26 dps Exp $ */

#include "tblock.h"
#ifndef NULL
#define NULL (void *) 0
#endif
#define __EXCLUDE_READER_CLASSES
#include "lib.h"


static const char *map_char(unsigned char s, const cmap *map, int n)
{
    int l, m, r;

    l=0;
    r=n-1;
    while (l<=r)
    {
	m=(l+r)/2;
	if (map[m].win==s)
	    return map[m].ascii;
	if (map[m].win<s)
	    l=m+1;
	if (map[m].win>s)
	    r=m-1;
    }
    return NULL;
}

tblock *__map_string(const char *s, const cmap *map, int map_size)
{
    const char *scan, *sptr;
    tblock *res;

    res=new(tblock);
    scan=s;
    while (*scan!='\0')
    {
	if ((sptr=map_char(*scan, map, map_size))==NULL)
	{
	    scan++;
	    continue;
	}
	if (scan!=s)
	    res->add(s, scan-s);
	res->add(sptr);
	scan++;
	s=scan;
    }    
    if (scan!=s)
	res->add(s, scan-s);

    return res;
}



