/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		prt_fs_of_rules.lex
Dates:		23 Sept. 2005
Purpose:	Print first set per rule.
How:	Read the rules' tree in prefix order filtering out:
			accepting only rule-def tokens.
			all other tokens with the grammar tree are bypassed
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |prt_fs_of_rules| grammar.\fbreak
Print out the {\bf First set} per rule definition.
The first set was created by |first_set_rules| grammar.
For ease of reading, I sort the terminals by their lexicographical order.

@/

fsm	
(fsm-id "prt_fs_of_rules.lex"
,fsm-filename prt_fs_of_rules
,fsm-namespace NS_prt_fs_of_rules
,fsm-class Cprt_fs_of_rules{
  user-prefix-declaration
#include "o2_externs.h"
  ***
  }
,fsm-version "1.0",fsm-date "26 sept. 2005",fsm-debug "false"
,fsm-comments "Print first set per rule")
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Rprt_first_set_rules AD AB()
{
  -> Rrules eog
}

Rrules AD AB(){
  -> Rrule_def
  -> Rrules Rrule_def
}

Rrule_def AD AB(){
  -> "rule-def" {
  /@
  Initialize for its subrule findings.
  @/ 
  op
    rule_def* rdef = sf->p1__;
    PRT_RULE_S_FIRST_SET(rdef);
  ***
  }
}
}// end of rules
