#ifndef _BC_GLOBALS_H
#define _BC_GLOBALS_H

#include "bc_ui.h"
#include <gfm.h>

typedef struct ref {
	char            ref_type[REF_TYPE_SIZE];
	char           *field[NUM_OF_FIELDS];
	char            open_char[NUM_OF_FIELDS + 1];
	char            close_char[NUM_OF_FIELDS + 1];
	char           *annote;
	char           *nsfield;
	struct ref     *next;
	struct ref     *prev;
}               Reference, *Ref;

struct ref_types_show_fct_struct {
	char           *ref_type_token;
	char           *ref_type_label;
	void            (*show_fct) ();
};

typedef struct sl {
	char           *selection;
	struct sl      *next;
}               SL, *SLIST;

extern FILE    *infile;

extern char     pathname[MAXPATHLEN], filename[MAXPATHLEN], *clipfile_name;
extern char    *text_fields[NUM_OF_FIELDS][2];

extern int      paste_flag, merge_flag, update_flag, mod_flag, mod_for_find_flag, selection_print_flag;
extern int      last_field;
extern int      selection_save_abbrev_flag;
extern int      edit_count, ns_edit_count, annote_edit_count;
extern int      total, max_total_for_list;
extern int      num_of_fields, citekey_id, key_id, year_id, author_id,
                editor_id;
extern int      book_id, inbook_id;
extern int      *found_flag;
extern int      default_ref_type;
extern int      default_find_ref_type;
extern int      default_find_field1;
extern int      default_find_field2;
extern int      default_find_field3;
extern int      default_find_field4;
extern int      default_find_field5;

extern int      default_find_connect;
extern int      default_find_findmethod;
extern int      default_find_ignore_case;
extern int      default_find_fuzzy_distance;
extern int      default_find_select_in_list;
extern int      offset_xv_y;

extern Ref      current_item, last_item, first_item;
extern Ref      ref, prev;

extern struct ref_types_show_fct_struct ref_types_show_fct[NUM_OF_REF_TYPES];

extern Panel_item field_ptr[NUM_OF_FIELDS], nxt_fld[NUM_OF_FIELDS], expand_item;

extern bc_base_window_objects *Bc_base_window;
extern bc_annotation_popup_objects *Bc_annotation_popup;
extern bc_ns_popup_objects *Bc_ns_popup;
extern bc_abbrev_popup_objects *Bc_abbrev_popup;
extern bc_expand_popup_objects *Bc_expand_popup;
extern bc_clip_buffer_popup_objects *Bc_clip_buffer_popup;
extern bc_list_popup_objects *Bc_list_popup;
extern bc_sort_popup_objects *Bc_sort_popup;
extern bc_find_popup_objects *Bc_find_popup;
extern bc_properties_popup_objects *Bc_properties_popup;

extern gfm_popup_objects 	*Gfm_Merge, *Gfm_Replace, *Gfm_Save_as, 	*Gfm_Save_Selection_with_abbrev, *Gfm_Save_Selection_no_abbrev;
extern char gfm_filter[BUFSIZ];

#endif				/* _BC_GLOBALS_H */
