/*
** Datei: DVITHIN.C
** Autor: Ingo Eichenseher
*/

#include <stdio.h>
#include <stdarg.h>
#include "dvi.h"
#include "dvihdcp.h"
#include "dviframe.h"

#ifdef SLOW_METHOD

static unsigned char nb = 0;

void thin_init(void)
{
}

static void thin(register unsigned char *line, int width)
{
    register int i, l;
    register unsigned char bit, b1, b2, *l1, *l2;

    l = 0; b1 = 64; b2 = 32; l1 = l2 = line;
    for (i=width*8; i--; line++)
    {
	for (bit=128; bit; bit>>=1)
	{
	    if (*line & bit)
	    {
		switch(l)
		{
		    case 0:
			l = 1; 
			break;
		    case 1: 
			*line &= ~bit;
			l = 2; 
			break;
		    case 2:
			if ( (*l1 & b1) && (*l2 & b2)==0)
			    *line &= ~bit;
			l = 3;
			break;
		    case 3:
			if (*l1 & b1)
			    *line &= ~bit;
			l = 2;
			break;
		}
	    }
	    else l=0;
	    if ((b1 >>= 1)==0)
	    {
		b1 = 128;
		if (i) l1++;
		else l1 = &nb;
	    }
	    if ((b2 >>= 1)==0) 
	    {
		b2 = 128; 
		if (i) l2++;
		else l2 = &nb;
	    }
	}
    }
}

void thin_out(unsigned char *buffer, int lines, int width)
{
    int *x = Logbase();
    while(lines--)
    {
	thin(buffer,width);
	buffer += width;
	*x ^= 0xFFFF;
    }
}

#else 

static int table[256*16];

static void thin_byte(int l_start, int b_end, int *table)
{
    register int i ,l;

    for (i=0; i<256; i++)
    {
	register unsigned char bit, bbyte, b;

	bbyte = i;
	l = l_start;
	for (bit=128; bit; bit>>=1)
	{
	    if (bit==1) b = b_end;
	    else if (bit==2) b = ((bbyte&1)<<1) | ((b_end>>1)&1);
	    else b = (((bit>>1)&bbyte) ? 2:0) | (((bit>>2)&bbyte) ? 1:0);
	    if (bbyte & bit)
	    {
		switch(l)
		{
		    case 0: 
			l = 1;
			break;
		    case 1: 
			bbyte &= ~bit;
			l = 2; 
			break;
		    case 2:
			if (b==2)
			    bbyte &= ~bit;
			l = 3;
			break;
		    case 3:
			if (b>=2)
			    bbyte &= ~bit;
			l = 2;
			break;
		}
	    }
	    else l=0;
	}
	table[i] = (l<<10) | bbyte;
    }
}

void thin_init(void)
{
    register int l, b;
    for (l=0; l<4; l++)
	for (b=0; b<4; b++)
	    thin_byte(l,b,&table[(l*4+b)<<8]);
}

void thin_out(int lines, int width)
{
    register unsigned int b, l = 0, w;
    register long line = 0;

    while(lines--)
    {
	w = width;
	while(--w)
	{
	    b = (frame_get(line+1)&0xC0)<<2;
	    l = table[l|b|frame_get(line)];
	    frame_poke(line,l);
	    line++;
	    l &= 0xff00;
	}
	frame_poke(line,table[l|frame_get(line)]);
	line++;
    }
}
#endif
