// $Id: BifStream.cc,v 1.1 2000/09/30 19:43:52 yotam Exp $

#include "BifStream.h"
#include "debug.h"

// The user is reponsible for testing success of
// opening prior of using get get<foo> functions.

static const US32 rightBits[] = 
                  {
                     0x00000000,
                     0x00000001,
                     0x00000003,
                     0x00000007,
                     0x0000000f,
                     0x0000001f,
                     0x0000003f,
                     0x0000007f,
                     0x000000ff
                  };

Int8
BifStream::get1byte()
{
   Int8  rc;
   get(rc);
   return(rc);
} // get1byte


US8
BifStream::get1ubyte()
{
   US8  rc;
   get(rc);
   return(rc);
} // get1ubyte


Int16
BifStream::get2byte()
{
   US8    byte[2];
   read(byte, 2);
   Int16  rc = (Int16)(((US32)(byte[0]) << 8) | (US32)byte[1]);
   return(rc);
} // get2byte


US16
BifStream::get2ubyte()
{
   US8    byte[2];
   read(byte, 2);
   US16  rc = (Int16)(((US32)(byte[0]) << 8) | (US32)byte[1]);
   return(rc);
} // get2ubyte



Int32
BifStream::get3byte()
{
   US8    byte[3];
   read(byte, 3);
   US32  u = (((US32)(byte[0]) << 16) |
              ((US32)(byte[1]) << 8) |
               (US32) byte[2]);
   if (byte[0] & 0x80) // negative
   {
      u |= 0xff000000;
   }
   Int32  rc = (Int32)u;
   return(rc);
} // get3byte


US32
BifStream::get3ubyte()
{
   US8    byte[3];
   read(byte, 3);
   US32  rc = (((US32)(byte[0]) << 16) |
               ((US32)(byte[1]) << 8) |
                (US32) byte[2]);
   return(rc);
} // get3ubyte


Int32
BifStream::get4byte()
{
   US8    byte[4];
   read(byte, 4);
   US32  u = (((US32)(byte[0]) << 24) |
              ((US32)(byte[1]) << 16) |
              ((US32)(byte[2]) << 8) |
               (US32) byte[3]);
   Int32  rc = (Int32)u;
   return(rc);
} // get4byte


US32
BifStream::get4ubyte()
{
   US8    byte[4];
   read(byte, 4);
   US32  rc = (((US32)(byte[0]) << 24) |
               ((US32)(byte[1]) << 16) |
               ((US32)(byte[2]) << 8) |
                (US32) byte[3]);
   return(rc);
} // get4ubyte


void
BifStream::bitscanFlush()
{
   nBitsCashed = 0;
} // bitscanFlush


US32
BifStream::getWordBits(US8 nBits)
{
   US32  rc = 0;

   DASSERT(nBits <= 32);
   DASSERT(nBitsCashed < 8);

   while (nBits)
   {
      if (nBitsCashed == 0)
      {
         get(savedByte);
         nBitsCashed = 8;
      }
      US8   nBitsFromCash  = (nBits < nBitsCashed ? nBits : nBitsCashed);
      nBitsCashed   -= nBitsFromCash;
      nBits         -= nBitsFromCash;
      US32  add = ((savedByte >> nBitsCashed) & rightBits[nBitsFromCash]);
      add <<= nBits;
      rc |= add;
   }
   return(rc);
} // getWordBits


US8
BifStream::getByteBits(US8 nBits)
{
   US8  rc = 0;

   DASSERT(nBits <= 8);
   DASSERT(nBitsCashed < 8);

   US8   nBitsFromCash = (nBits < nBitsCashed ? nBits : nBitsCashed);
   if (nBitsFromCash)
   {
      US8   unmask = nBitsCashed - nBitsFromCash;
      US32  mask = rightBits[nBitsCashed] ^ rightBits[unmask];
      rc = savedByte & mask;
      nBits -= nBitsFromCash;
      nBitsCashed -= nBitsFromCash;
      DASSERT(nBits == 0 || nBitsCashed == 0);
      rc <<= nBits;
      rc >>= nBitsCashed;
   }
   if (nBits)
   {
      DASSERT(nBitsCashed == 0);
      get(savedByte);
      nBitsCashed = 8 - nBits;
      rc |= ((savedByte >> nBitsCashed) & rightBits[nBits]);
   }
   return(rc);
} // getByteBits


US8
BifStream::get4bits()
{
   US8  rc;

   DASSERT(0 <= nBitsCashed && nBitsCashed < 8);
   if (nBitsCashed % 4 != 0) 
   {
      rc = getByteBits(4);
   }
   else
   {
      if (nBitsCashed)
      {                                   DASSERT(nBitsCashed == 4);
         rc = savedByte & 0xf;   
         nBitsCashed = 0;
      }
      else
      {
         get(savedByte);                  DASSERT(nBitsCashed == 0);
         rc = (savedByte >> 4) & 0xf;
         nBitsCashed = 4;
      }
   }
   return(rc);
} // get4bits



#ifdef TEST
using namespace std;

int main(int argc, char **argv)
{
   const char *dfn = "/tmp/fintval.dmp";

      int    i;
      Int8   int8[4];
      US8    us8[4];
      Int16  int16[2];
      US16   us16[2];
      Int32  int32;
      US32   us32 = 1;

   while (us32)
   {
      // cin.seekg(0, ios::end);  cin.sync();/// How to flush/discrad cin ???
      // cin.seekg(0, ios::end);
      cout << "Enter 4 unsigned char numbers\n";
      for (i = 0;  i < 4;  i++)
      {
         int  n = 0;
         cin >> n;
         us8[i] = (US8)n;
      }
      cout << "Got: ";
      for (i = 0;  i < 4;  i++)
      {
         cout << dec << "[" << i << "] " << (US16)us8[i] <<
                 hex << " " << (US16)us8[i]
              << ", ";
      }
      cout << "\n Now casting:\n" <<
              "4*Int8: ";
      for (i = 0;  i < 4;  i++)
      {
         Int8  i8 = (Int8)us8[i];
         cout << dec << "[" << i << "] " << (Int16)i8 << "  ";
      }
      cout << "\n";

      for (i = 0;  i < 2;  i++)
      {
         us16[i] = (US16)(( ((US32)us8[2*i]) << 8) | (US32)us8[2*i + 1]);
         int16[i] = (Int16)us16[i];
      }
      cout << "2* US16: " << dec << us16[0] << " =x " << hex << us16[0] << ", "
                          << dec << us16[1] << " =x " << hex << us16[1] <<
           "\n 2*Int16 " << dec << int16[0] << ", " << int16[1] << "\n";

      us32 = ((US32)us16[0] << 16) | (US32)us16[1];
      int32 = (Int32)us32;
      cout << "US32= " << dec << us32 << " =x" << hex << us32 << "\n" <<
              "Int32=" << dec << int32 << "\n";

      ofstream  odfn(dfn, ios::out | ios::bin);
      if (!odfn)
      {
         cerr << "Failed to open output " << dfn << "\n";
         return(1);
      }
      odfn.write(us8, 4);
      odfn.close();

      BifStream  idfn(dfn);
      if (!idfn)
      {
         cerr << "Failed to open input " << dfn << "\n";
         return(1);
      }
      cout << "\n\n Getting from << dfn << \n";

      cout << "US8: ";
      for (i = 0;  i < 4;  i++)
      {
         US8 u = idfn.get1ubyte();
         cout << dec << "[" << i << "]" << (US16)u << " x" <<
                                    hex << (US16)u << ", ";
      }
      cout << "\n";

      idfn.seekg(0);
      cout << "Int8: ";
      for (i = 0;  i < 4;  i++)
      {
         Int8 i8 = idfn.get1byte();
         cout << dec << "[" << i << "]" << (Int16)i8 << ", ";
      }
      cout << "\n";

      idfn.seekg(0);
      cout << "US16: ";
      for (i = 0;  i < 2;  i++)
      {
         US16 u = idfn.get2ubyte();
         cout << dec << "[" << i << "]" << u << " x" << hex << u << ", ";
      }
      cout << "\n";

      idfn.seekg(0);
      cout << "Int16: ";
      for (i = 0;  i < 2;  i++)
      {
         Int16 i8 = idfn.get2byte();
         cout << dec << "[" << i << "]" << i8 << ", ";
      }
      cout << "\n";

      idfn.seekg(0);
      us32 = idfn.get3ubyte();
      cout << "U32 (3): " << dec <<  us32 << " x" << hex << us32 << "\n";

      idfn.seekg(0);
      int32 = idfn.get3byte();
      cout << "Int32 (3): " << dec <<  int32 << "\n";

      idfn.seekg(0);
      us32 = idfn.get4ubyte();
      cout << "U32 (4): " << dec <<  us32 << " x" << hex << us32 << "\n";

      idfn.seekg(0);
      int32 = idfn.get4byte();
      cout << "Int32 (4): " << dec <<  int32 << "\n";

      idfn.seekg(0);
      cout << "4-bits:\n";
      idfn.bitscanFlush();
      for (i = 0;  i < 8;  i++)
      {
         US16  u = idfn.get4bits();
         cout << dec << "[" << i << "] " << u << " x" << hex << u << ", ";
      }
      cout << "\n";

      idfn.seekg(0);
      cout << "1,2,3,4,5,6,7-bits:\n";
      idfn.bitscanFlush();
      for (i = 1;  i <= 7;  i++)
      {
         US16  u = idfn.getByteBits(i);
         cout << dec << "[" << i << "] " << u << " x" << hex << u << ", ";
      }
      cout << "\n";

      idfn.seekg(0);
      cout << "10,4,18-bits:\n";
      idfn.bitscanFlush();
      for (i = 0;  i < 3;  i++)
      {
         static  nb[] = {10, 4, 18};
         int     n = nb[i];
         US32  u = idfn.getWordBits(n);
         cout << dec << "[" << n << "] " << u << " x" << hex << u << ", ";
      }
      cout << "\n";

      idfn.close();
   }
   return(0);
} // main

#endif /* TEST */
