#!/usr/bin/env python
# -*- python -*-
# $Id: tfmpk.py,v 1.5 2001/03/07 20:47:07 yotam Exp $

# Standard:
import string;
import sys;
import os;
import GDK;
import gtk;
import gnome.ui;
import gnome.uiconsts;
import GdkImlib;
# import gnome.config;

# Mine:
import Font;
import OpenFont;
import about;
import gnomegoods;
import gtkgoods;
import osgoods;

def debugReload(item):
   global appTfmPk;
   print "Destroying1..."
   appTfmPk.app.destroy()
   print "Destroying2..."
   del appTfmPk;
   print "Restarting..."
   execfile("tfmpk")
   print "How is it?..."

class AppTfmPk:
   def openFont(self,item):
      if not 'open' in self.dialogs.keys():
         # print "openDlg virgin"
         self.dialogs['open'] = OpenFont.dialog(self.load,
                                                self._tfmpath, self._pkpath,
                                                self);
         self.dialogs['open'].connect("destroy", self.destroy_cb, 'open');
      dlg = self.dialogs['open'];
      dlg.show();
      dlg.map();
      dlg.get_window()._raise();

   def __init__(self):
      self.getCmdLineArgs();
      winMainName = "TFMPK - Main";
      self.app = gnome.ui.GnomeApp('tfmpk', winMainName);
      self.app.set_uposition(100,100);
      self.app.set_wmclass('tfmpk', 'Tfmpk');
      self.app.connect('delete_event', gtk.mainquit)
      self.app.connect('destroy', gtk.mainquit)

      file_menu = [
         (gnome.uiconsts.APP_UI_ITEM, 'Open...', None, self.openFont, None,
          gnome.uiconsts.APP_PIXMAP_STOCK,
          gnome.uiconsts.STOCK_MENU_OPEN, 0, 0),
         (gnome.uiconsts.APP_UI_ITEM, 'Re-open', None, self.reload, None,
          gnome.uiconsts.APP_PIXMAP_STOCK,
          gnome.uiconsts.STOCK_MENU_REFRESH, 0, 0),
         (gnome.uiconsts.APP_UI_ITEM, 'Unload', None, self.unload, None,
          gnome.uiconsts.APP_PIXMAP_STOCK,
          gnome.uiconsts.STOCK_PIXMAP_CLOSE, 0, 0),
         (gnome.uiconsts.APP_UI_ITEM, 'Exit', None, gtk.mainquit, None,
          gnome.uiconsts.APP_PIXMAP_STOCK,
          gnome.uiconsts.STOCK_MENU_EXIT, 0, 0)
         #gnome.uiconsts.UIINFO_SEPARATOR,
         #(gnome.uiconsts.APP_UI_ITEM, 'Debug-Reload', None, debugReload, None,
         # gnome.uiconsts.APP_PIXMAP_STOCK,
         # gnome.uiconsts.STOCK_MENU_REVERT, 0, 0)
      ]

      options_menu = [
         (gnome.uiconsts.APP_UI_ITEM, 'Preferences...', None, self.pref_cb,
          None,
          gnome.uiconsts.APP_PIXMAP_STOCK,
          gnome.uiconsts.STOCK_MENU_PREF, 0, 0),
      ]

      windows_menu = self.windows_menu = [
         (gnome.uiconsts.APP_UI_ITEM, 'Metrics', None,
          self.ShowFontWin(self, Font.winMetrics).show,
          None,
          gnome.uiconsts.APP_PIXMAP_STOCK,
          gnome.uiconsts.STOCK_PIXMAP_PROPERTIES, 0, 0),
         (gnome.uiconsts.APP_UI_ITEM, 'Faces', None,
          self.ShowFontWin(self, Font.winFaces).show,
          None,
          gnome.uiconsts.APP_PIXMAP_STOCK,
          gnome.uiconsts.STOCK_PIXMAP_TABLE_FILL, 0, 0),
         (gnome.uiconsts.APP_UI_ITEM, 'Focus', None,
          self.ShowFontWin(self, Font.winFocus).show,
          None,
          gnome.uiconsts.APP_PIXMAP_STOCK,
          gnome.uiconsts.STOCK_MENU_MIC, 0, 0),
         (gnome.uiconsts.APP_UI_ITEM, 'About Font', None,
          self.ShowFontWin(self, Font.winAbout).show,
          None,
          gnome.uiconsts.APP_PIXMAP_STOCK,
          gnome.uiconsts.STOCK_MENU_ABOUT, 0, 0),
         gnome.uiconsts.UIINFO_SEPARATOR,
         (gnome.uiconsts.APP_UI_ITEM, 'All Above', None,
          self.showFontWins,
          None,
          gnome.uiconsts.APP_PIXMAP_STOCK,
          gnome.uiconsts.STOCK_MENU_BOOK_GREEN, 0, 0),
         (gnome.uiconsts.APP_UI_ITEM, 'Hide', None,
          self.hideFontWins,
          None,
          gnome.uiconsts.APP_PIXMAP_STOCK,
          gnome.uiconsts.STOCK_MENU_BLANK, 0, 0),
      ]

      help_menu = [
         (gnome.uiconsts.APP_UI_ITEM, 'About', None, about.about, None,
          gnome.uiconsts.APP_PIXMAP_STOCK,
          gnome.uiconsts.STOCK_MENU_ABOUT, 0, 0),
      ]

      menu = [
         gnome.uiconsts.UIINFO_SUBTREE('File', file_menu),
         gnome.uiconsts.UIINFO_SUBTREE('Options', options_menu),
         gnome.uiconsts.UIINFO_SUBTREE('Windows', windows_menu),
         gnome.uiconsts.UIINFO_SUBTREE('Help', help_menu)
      ]

      self.app.create_menus(menu)

      self._tooltips = gtk.GtkTooltips();
      self._tooltips.enable();

      mainbox = gtk.GtkHBox(spacing=6);
      mainbox.set_border_width(6);
      self.fontlist = fontlist = gtk.GtkCList(1, ["Loaded Fonts"]);
      fontlist.set_column_auto_resize(0, 1);
      fontlist.connect('event', self.fontlist_cb);
      fontlist.thaw();
      fontlist.show();
      mainbox.pack_start(fontlist, expand=1, fill=1, padding=5);
      thisDir = string.join(string.split(sys.argv[0], '/')[:-1], '/');
      # print "thisDir=", thisDir;
      mfbk = thisDir + '/mfbk.png';
      try:
         im = GdkImlib.Image(mfbk);
      except RuntimeError:
         print "load image of %s failed" % mfbk;
         im = None;
      if im != None:
         im.render();
         pix = im.make_pixmap();
         pix.show();
         mainbox.pack_start(pix, expand=0, fill=0, padding=4);

      mainbox.show();
      self.app.set_contents(mainbox);
      self.app.show();
      # show.app.ensure_style();
      gtkgoods.gflush(); # not to be effected by future (fixed) fonts 

      self.dialogs = {};
      self.fonts = {};
      self.name2font = {};
      if self._loadtfmfn != None and self._loadpkfn != None:
         self.load(self._loadtfmfn, self._loadpkfn);
      if self.snap:
         snapsh = open("snap.sh", "w", 0755);
         snapsh.write("#!/bin/sh\n")
         fKeys = self.fonts.keys();
	 self.importCmd = "import";
	 if len(fKeys):
	    self.fonts[fKeys[0]].snap(snapsh, self.snapname);
         gtkgoods.snapshot(snapsh, self.app, "%s-main" % self.snapname);
         snapsh.write("kill -9 %d\n" % os.getpid()); # Kill myself
         snapsh.close();
         os.chmod("snap.sh", 0755);
         # Now run the script ion the background, so we can respond
         # to X11's windows refresh events.
         osgoods.esystem("./snap.sh&"); #  
         gtkgoods.gflush();
	 # gtk.mainquit(); # Better to send quit event, but how?

   def load(self, tfmfn, pkfn):
      # print "tfmpk.load(%s, %s)\n" % (tfmfn, pkfn)
      if (tfmfn,pkfn) in self.fonts.keys():
         gnomegoods.warn("Pair tfm+pk files already loaded");
         #  The above is (currently?) better since it grabs
         #  and does not create extra windows.
         # self.app.warning("Pair tfm+pk files already loaded");
      else:
         # print "New pair to load";
         font = Font.Font(self, tfmfn, pkfn);
         if font.ok():
            self.fonts[tfmfn, pkfn] = font;
            fontName = fontBaseName = font.name();
            n = 1;
            while fontName in self.name2font.keys():
               n = n + 1;
               fontName = "%s<%d>" % (fontBaseName, n);
            self.name2font[fontName] = font;
            self.fontlist.append([fontName]);

   def unload(self, item):
      fontI = self.currFontIndex();
      if fontI == -1:
         gnomegoods.warn("No selected font to unload");
      else:
         font = self.currFontAt(fontI);
         fontName = self.fontlist.get_text(fontI, 0);
         font = self.name2font[fontName];
         self.fontlist.remove(fontI);
         del self.fonts[font._tfmfn, font._pkfn];
         del self.name2font[fontName];
         font.close();

   def reload(self, item):
      fontI = self.currFontIndex();
      if fontI == -1:
         gnomegoods.warn("No selected font to reload");
      else:
         font = self.currFontAt(fontI);
         fontName = self.fontlist.get_text(fontI, 0);
         font = self.name2font[fontName];
         self.fontlist.remove(fontI);
         del self.fonts[font._tfmfn, font._pkfn];
         del self.name2font[fontName];
         font.close();
         self.load(font._tfmfn, font._pkfn);

   def currFontIndex(self):
      fontlist = self.fontlist
      fontI = -1;
      selFontList = fontlist.selection;
      if len(selFontList):
         fontI = selFontList[0];
      elif fontlist.rows == 1:
         fontI = 0;
      return fontI;

   def currFontAt(self, fontI):
      font = None;
      if fontI != -1:
         fontName = self.fontlist.get_text(fontI, 0);
         font = self.name2font[fontName];
      return font;

   def currFont(self):
      fontI = self.currFontIndex();
      font = self.currFontAt(fontI);
      return font;

   class ShowFontWin:
      def __init__(self, appObj, winIndex):
         self._app = appObj;
         self._winIndex = winIndex;
      def show(self, item):
         # print "ShowFontWin.show, winIndex=", self._winIndex;
         font = self._app.currFont();
         if font == None:
            gnomegoods.warn("No selected loaded font for which to show window");
         else:
            font.show(self._winIndex);


   def showFontWins(self, item):
      font = self.currFont();
      if font == None:
         gnomegoods.warn("No selected loaded font to show");
      else:
         font.showFontWins();
         self.app.get_window()._raise();  # So the main dialog will not be lost

   def hideFontWins(self, item):
      font = self.currFont();
      if font == None:
         gnomegoods.warn("No selected loaded font to hide");
      else:
         font.hideFontWins();

   def destroy_cb(self, w, key):
      del self.dialogs[key];

   def fontlist_cb(self, w, event):
      if event.type == GDK._2BUTTON_PRESS:
         self.showFontWins(2000); # dum item

   def pref_cb(self, item):
      gnomegoods.warn("Preferences not yet supported");

   def getCmdLineArgs(self):
      self._tfmpath = None;
      self._pkpath = None;
      self._loadtfmfn = None;
      self._loadpkfn = None;
      self.snap = 0;
      arg0 = sys.argv[0];
      i = 2; #
      nArgs = len(sys.argv);
      while i < nArgs:
         i1 = i + 1;
         a = sys.argv[i];
         a1 = None;
         if i1 < nArgs: a1 = sys.argv[i1];
         # print "arg[%d]=%s" % (i, a)
         if a == '-help' or a == '--help':
            self.usage(arg0, 0);
         elif a == '-tfmpath':
            if a1 == None: self.usage(arg0, 1);
            self._tfmpath = a1;
            i = i + 1;
         elif a == '-pkpath':
            if a1 == None: self.usage(arg0, 1);
            self._pkpath = a1;
            i = i + 1;
         elif a == '-load':
            i = i + 2;
            if i >= nArgs: self.usage(arg0, 1);
            self._loadtfmfn = a1;
            self._loadpkfn = sys.argv[i];
         elif a == '-snap':
	    self.snap = 1;
            if a1 == None: self.usage(arg0, 1);
            self.snapname = a1;
            i = i + 1;
         elif a == '--':
            pass; # ignore
         else:
            print "Unexpected option: ", a;
            self.usage(arg0, 1);
         i = i + 1;
      # print "_tfmpath=%s, _pkpath=%s" % (self._tfmpath, self._pkpath)

   def setTip(self, w, tip):
      # print "setTip: w=", w, ", tip=", tip;
      self._tooltips.set_tip(w, tip);
      self._tooltips.enable(); # needed again?


   def usage(self, arg0, excode):
      usageText = """
Usage:
   tfmpk [-tfmpath <path>] [-pkpath <path>]
         [-load <tfm-filename> <pk-filename>]
"""
      print usageText;
      sys.exit(excode);


if __name__ == '__main__':
   # global appTfmPk;
   appTfmPk = AppTfmPk()
   gtk.mainloop()
