/*
  This is the file error.c of the CJK macro package ver. 4.1.3
  (20-Jun-1997).
*/


#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include "error.h"


char *ttf_err_message[] = {
  "Invalid file name: %s",          /* ttf_err_invalid_filename */
  "Read error: errno = %i",         /* ttf_err_read */
  "Allocation error",               /* ttf_err_out_of_memory */
  "Invalid TTF table: tag %s",      /* ttf_err_invalid_table */
  "Invalid TTF format",             /* ttf_err_invalid_format */
  "composite TTF not implemented",  /* ttf_err_not_implemented */
  "Invalid TTF version",            /* ttf_err_invalid_version */
  "No TTF head table",              /* ttf_err_need_head_table */
  "No TTF maxp table",              /* ttf_err_need_maxp_table */
  "Invalid TTF prep table",         /* ttf_err_invalid_prep */
  "Invalid TTF index",              /* ttf_err_invalid_index */
  "File open error" };              /* ttf_err_openfile */


/* if this value is true, various debugging messages will be print */
int ttf_debug = 0;


/*@@*/

void ttf_error(er /* , ... */)
  ttf_err_type er;
{
  va_list ap;

  va_start(ap, er);
  fprintf(stderr, "ttf2pk: ");
  vfprintf(stderr, ttf_err_message[er], ap);
  fprintf(stderr, "\n\n");
  va_end(ap);

  exit(1);
}


#ifdef DEBUG

void *ttf_malloc(size, function)
  size_t size;
  char *function;
{
  void *d = malloc(size);

  if (ttf_debug)
    fprintf(stderr, "TTF: allocating %p, %d bytes, function %s\n",
            d, size, function);

  if (d == NULL)
    ttf_error(ttf_err_out_of_memory);

  return d;
}


void *ttf_realloc(ptr, size, function)
  void *ptr;
  size_t size;
  char *function;
{
  void *d = realloc(ptr, size);

  if (ttf_debug)
    fprintf(stderr, "TTF: reallocating %p to %p, %d bytes, function %s\n",
            ptr, d, size, function);

  if (d == NULL)
    ttf_error(ttf_err_out_of_memory);

  return d;
}


void ttf_free(ptr, function)
  void *ptr;
  char *function;
{
  free(ptr);

  if (ttf_debug)
    fprintf(stderr, "TTF: freeing %p, function %s\n", ptr, function);
}

#else /* DEBUG */

void *ttf_malloc(size)
  size_t size;
{
  void *d = malloc(size);

  if (d == NULL)
    ttf_error(ttf_err_out_of_memory);

  return d;
}


void *ttf_realloc(ptr, size)
  void *ptr;
  size_t size;
{
  void *d = realloc(ptr, size);

  if (d == NULL)
    ttf_error(ttf_err_out_of_memory);

  return d;
}


void ttf_free(void *ptr)
{
  free(ptr);
}

#endif /* DEBUG */


/* end of error.c */
