(* Global declarations for DVItoVDU *)

CONST
   (* Character bitmap sizes in 32-bit words.
      Note that "W" in cminch.432pk requires 8640 words.
   *)
   small_size = 50;      (* handles most 10..12pt char bitmaps at 300dpi *)
   big_size   = 100;
   large_size = 500;
   huge_size  = 10000;

   maxstring  = 80;
   maxstringm = maxstring - 1;

TYPE
   string = PACKED ARRAY [0..maxstringm] OF CHAR;

   BITSETPTR = ^BITSET;        (* pointer to 32-bit word *)
   BITSET    = SET OF 0..31;

   (* The following variant records are needed because Pyramid Pascal
      does not provide type coercion.
      Note that we couldn't overlay INTEGER and BITSET because
      of the crazy storage scheme used to represent a set of 0..31
      where the bit order within a word is 7..0 15..8 23..16 31..24!
   *)

   bytes_or_bits = RECORD
                   CASE b : BOOLEAN OF
                      TRUE  : (ch   : PACKED ARRAY [0..3] OF CHAR);
                      FALSE : (bits : BITSET);
                   END;

   int_or_bptr = RECORD
                 CASE b : BOOLEAN OF
                    TRUE  : (int  : INTEGER);
                    FALSE : (bptr : BITSETPTR);
                 END;

   bitmap_size = (small,big,large,huge);
   bitmap_ptr  = ^bitmap_rec;
   bitmap_rec  = RECORD
                 CASE bitmap_size OF
                    small : (s : PACKED ARRAY [1..small_size] OF BITSET);
                    big   : (b : PACKED ARRAY [1..big_size] OF BITSET);
                    large : (l : PACKED ARRAY [1..large_size] OF BITSET);
                    huge  : (h : PACKED ARRAY [1..huge_size] OF BITSET);
                 END;

   int_or_mptr = RECORD
                 CASE b : BOOLEAN OF
                    TRUE  : (int  : INTEGER);
                    FALSE : (mptr : bitmap_ptr);
                 END;

PROCEDURE exit (status : integer);   EXTERNAL;
               (* 0 = success, 1 = error *)
