/*
 * (c) Copyright 2001-2003 Yann-Gal Guhneuc,
 * cole des Mines de Nantes and Object Technology International, Inc.
 * 
 * Use and copying of this software and preparation of derivative works
 * based upon this software are permitted. Any copy of this software or
 * of any derivative work must include the above copyright notice of
 * the author, this paragraph and the one after it.
 * 
 * This software is made available AS IS, and THE AUTHOR DISCLAIMS
 * ALL WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, AND NOT WITHSTANDING ANY OTHER PROVISION CONTAINED HEREIN,
 * ANY LIABILITY FOR DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS
 * EXPRESSLY DISCLAIMED, WHETHER ARISING IN CONTRACT, TORT (INCLUDING
 * NEGLIGENCE) OR STRICT LIABILITY, EVEN IF THE AUTHOR IS ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 * 
 * All Rights Reserved.
 */
package bibtex.example;

import java.io.PrintWriter;

import bibtex.dom.BibtexConcatenatedValue;
import bibtex.dom.BibtexEntry;
import bibtex.dom.BibtexField;
import bibtex.dom.BibtexFile;
import bibtex.dom.BibtexKey;
import bibtex.dom.BibtexPreamble;
import bibtex.dom.BibtexString;
import bibtex.dom.BibtexStringDefinition;
import bibtex.dom.BibtexStringReference;
import bibtex.dom.BibtexToplevelComment;
import bibtex.visitor.BibtexVisitor;

/**
 * @author	Yann-Gal Guhneuc
 */
public class PrintVisitor implements BibtexVisitor {
	private final PrintWriter writer;

	public PrintVisitor(final PrintWriter writer) {
		this.writer = writer;
	}
	public void close(final BibtexField bibtexField) {
	}
	public void close(final BibtexFile bibtexFile) {
	}
	public void close(final BibtexEntry bibtexEntry) {
		writer.println("}");
	}
	public void open(final BibtexEntry bibtexEntry) {
		writer.print('@');
		writer.print(bibtexEntry.getType());
		writer.print('{');
		writer.print(bibtexEntry.getKey());
		writer.println(',');
	}
	public void open(final BibtexField bibtexField) {
	}
	public void open(final BibtexFile bibtexFile) {
	}
	public void visit(final BibtexConcatenatedValue bibtexConcatenatedValue) {
		writer.println(bibtexConcatenatedValue.getLeft());
		writer.println(bibtexConcatenatedValue.getRight());
	}
	public void visit(final BibtexKey bibtexKey) {
		writer.print('\t');
		writer.print(bibtexKey.getValue());
		writer.print("=");
	}
	public void visit(final BibtexPreamble bibtexPreamble) {
		writer.println(bibtexPreamble.getContent());
	}
	public void visit(final BibtexString bibtexString) {
		writer.print('{');
		writer.print(bibtexString.getValue());
		writer.println("},");
	}
	public void visit(final BibtexStringDefinition bibtexStringDefinition) {
		writer.print('\n');
		writer.print(bibtexStringDefinition.getKey());
		writer.print("={");
		writer.print(bibtexStringDefinition.getValue());
		writer.println("}");
	}
	public void visit(final BibtexStringReference bibtexStringReference) {
		writer.println(bibtexStringReference.getValue());
	}
	public void visit(final BibtexToplevelComment bibtexToplevelComment) {
		writer.println(bibtexToplevelComment.getContent());
	}
}
