import javax.swing.*;

/*
 * StringEditGUI.java
 *
 * Created on 6. December 2006, 17:10
 */

/**
 *
 * @author  Olle Nebendahl
 */
public class DialogGUI extends JDialog {
    
    public JButton[] button;
    private JPanel jPanel2;
    private JTextField jTextField1;
    public String approved;
    
    public JLabel[] label;
    public JTextField[] textField;


    /** Creates new form NewJFrameo */
    public DialogGUI(java.awt.Dialog owner, String title, boolean modal, String[] buttons, String[] textFields)
    {
        super(owner,title,modal);
        initComponents(buttons,textFields);
    }
    
    public DialogGUI(java.awt.Frame owner, String title, boolean modal, String[] buttons, String[] textFields)
    {
        super(owner,title,modal);
        initComponents(buttons,textFields);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     */
    private void initComponents(String[] buttons, String[] textFields)
    {
        JPanel textFieldPanel = new JPanel();
        JPanel buttonPanel = new JPanel();

        int textFieldCount=textFields.length;
        int buttonCount = buttons.length;

        JPanel[] leftPanel = new JPanel[textFieldCount];
        label = new JLabel[textFieldCount];
        textField = new JTextField[textFieldCount];
        
        button = new JButton[buttonCount];
        
        int i = 0;
        int l = textFieldCount;
        while(i<l)
        {
            label[i]= new JLabel(textFields[i]);
            textField[i]=new JTextField();
            textField[i].setPreferredSize(new java.awt.Dimension(248, 22));
            leftPanel[i]=new JPanel();
            leftPanel[i].setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));
            leftPanel[i].add(label[i]);
            leftPanel[i].add(textField[i]);
            textFieldPanel.add(leftPanel[i]);
            i++;
        }
        
        if(i>0)
        {   
            getContentPane().add(textFieldPanel);
            getContentPane().add(new JSeparator());
        };
        
        i=0;
        l=buttonCount;
        while(i<l)
        {
            button[i]=new JButton(buttons[i]);
            button[i].addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                    buttonsActionPerformed(evt);
                }
            });
            buttonPanel.add(button[i]);
            i++;
        }

        getContentPane().setLayout(new BoxLayout(getContentPane(), BoxLayout.Y_AXIS));
        getContentPane().add(buttonPanel);

        setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
        setResizable(false);
        buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.X_AXIS));
        textFieldPanel.setLayout(new BoxLayout(textFieldPanel, BoxLayout.Y_AXIS));
        

        pack();
    }
    
    private void buttonsActionPerformed(java.awt.event.ActionEvent evt) 
    {
        approved=((JButton)evt.getSource()).getText();
        setVisible(false);
    }
    
    
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) 
    {
/*        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new DialogGUI(new JFrame(),"Olle",true).setVisible(true);
            }
  });*/      
        System.out.println("Start");
        JFrame frame = new JFrame();
        DialogGUI sg = new DialogGUI(frame,"TestDialog",true,args,args);
        sg.setVisible(true);
        System.out.println("Stop");        
        System.out.println(sg.textField[1].getText());
    }
    
}
