/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.console;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.exception.UserInterruptException;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.installer.util.PanelHelper;
import com.izforge.izpack.util.Console;
import java.io.PrintWriter;
import java.util.ArrayList;

public abstract class AbstractConsolePanel
implements ConsolePanel {
    private final PanelView<ConsolePanel> panel;

    public AbstractConsolePanel(PanelView<ConsolePanel> panel) {
        this.panel = panel;
    }

    @Override
    public boolean generateProperties(InstallData installData, PrintWriter printWriter) {
        return true;
    }

    protected boolean promptEndPanel(InstallData installData, Console console) {
        boolean result;
        Messages messages = installData.getMessages();
        String prompt = messages.get("ConsoleInstaller.continueQuitRedisplay", new Object[0]);
        console.println();
        int value = console.prompt(prompt, 1, 3, 2);
        switch (value) {
            case 1: {
                result = true;
                break;
            }
            case 2: {
                throw new UserInterruptException(messages.get("ConsoleInstaller.aborted.PressedQuit", new Object[0]));
            }
            default: {
                result = this.run(installData, console);
            }
        }
        return result;
    }

    protected boolean promptRerunPanel(InstallData installData, Console console) {
        Messages messages = installData.getMessages();
        String prompt = messages.get("ConsoleInstaller.redisplayQuit", new Object[0]);
        console.println();
        int value = console.prompt(prompt, 1, 2, 2);
        switch (value) {
            case 2: {
                throw new UserInterruptException(messages.get("ConsoleInstaller.aborted.PressedQuit", new Object[0]));
            }
        }
        boolean result = this.run(installData, console);
        return result;
    }

    protected Panel getPanel() {
        return this.panel != null ? this.panel.getPanel() : null;
    }

    @Override
    public void createInstallationRecord(IXMLElement rootElement) {
    }

    @Override
    public boolean run(InstallData installData, Console console) {
        this.printHeadLine(installData, console);
        return true;
    }

    protected void printHeadLine(InstallData installData, Console console) {
        String headline = this.getI18nStringForClass("headline", installData);
        if (headline != null) {
            console.println();
            console.printFilledLine('\u2500');
            console.println(headline);
            console.printFilledLine('\u2500');
            console.println();
        }
    }

    @Override
    public boolean handlePanelValidationResult(boolean valid) {
        return valid;
    }

    public String getI18nStringForClass(String subkey, InstallData installData) {
        return this.getI18nStringForClass(subkey, null, installData);
    }

    public String getI18nStringForClass(String subkey, String alternateClass, InstallData installData) {
        String simpleClassname;
        String retval = null;
        ArrayList<String> prefixes = new ArrayList<String>();
        Panel panel = this.getPanel();
        String panelId = null;
        if (panel != null) {
            panelId = this.getPanel().getPanelId();
        }
        Class<IzPanel> clazz = PanelHelper.getIzPanel(this.getClass().getName());
        String fullClassname = alternateClass == null ? clazz.getName() : alternateClass;
        String string = simpleClassname = alternateClass == null ? clazz.getSimpleName() : alternateClass;
        do {
            if (panelId != null) {
                prefixes.add(fullClassname + "." + panelId);
                prefixes.add(simpleClassname + "." + panelId);
            }
            prefixes.add(fullClassname);
            prefixes.add(simpleClassname);
            clazz = clazz.getSuperclass();
            if (clazz == null) continue;
            fullClassname = clazz.getName();
            simpleClassname = clazz.getSimpleName();
        } while (alternateClass == null && clazz != null && !clazz.equals(AbstractConsolePanel.class));
        if (panelId != null) {
            prefixes.add(2, panelId);
        }
        for (String prefix : prefixes) {
            String searchkey = prefix + "." + subkey;
            if (installData.getMessages().getMessages().containsKey(searchkey)) {
                retval = installData.getMessages().get(searchkey, new Object[0]);
            }
            if (retval == null) continue;
            break;
        }
        if (retval != null && retval.indexOf(36) > -1) {
            retval = installData.getVariables().replace(retval);
        }
        return retval;
    }
}

