/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.bibeditor;

import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.bibeditor.BibCompletionProcessor;
import net.sourceforge.texlipse.bibeditor.BibEditor;
import net.sourceforge.texlipse.editor.TexAnnotationHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class BibSourceViewerConfiguration
extends SourceViewerConfiguration {
    private BibEditor editor;
    private TexAnnotationHover annotationHover;
    private ContentAssistant assistant;

    public BibSourceViewerConfiguration(BibEditor te) {
        this.editor = te;
        this.annotationHover = new TexAnnotationHover();
        TexlipsePlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (BibSourceViewerConfiguration.this.assistant == null) {
                    return;
                }
                String property = event.getProperty();
                System.out.println(property);
                if ("bibCompletion".equals(property)) {
                    BibSourceViewerConfiguration.this.assistant.enableAutoActivation(TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("bibCompletion"));
                } else if ("bibDelay".equals(property)) {
                    BibSourceViewerConfiguration.this.assistant.setAutoActivationDelay(TexlipsePlugin.getDefault().getPreferenceStore().getInt("bibDelay"));
                }
            }
        });
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return this.annotationHover;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "__bibtex_partitioning";
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__bib_entry"};
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        TexlipsePlugin.getDefault().getBibColorProvider();
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)TexlipsePlugin.getDefault().getBibCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)TexlipsePlugin.getDefault().getBibEntryScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__bib_entry");
        reconciler.setRepairer((IPresentationRepairer)dr, "__bib_entry");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        this.assistant = new ContentAssistant();
        this.assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        this.assistant.setContentAssistProcessor((IContentAssistProcessor)new BibCompletionProcessor(this.editor.getDocumentModel()), "__bib_entry");
        this.assistant.setContentAssistProcessor((IContentAssistProcessor)new BibCompletionProcessor(this.editor.getDocumentModel()), "__dftl_partition_content_type");
        this.assistant.enableAutoActivation(TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("bibCompletion"));
        this.assistant.enableAutoInsert(true);
        this.assistant.setAutoActivationDelay(TexlipsePlugin.getDefault().getPreferenceStore().getInt("bibDelay"));
        this.assistant.setProposalPopupOrientation(10);
        this.assistant.setContextInformationPopupOrientation(20);
        this.assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return this.assistant;
    }
}

