/* This file was generated by SableCC (http://www.sablecc.org/). */

package net.sourceforge.texlipse.texparser.lexer;

import java.io.*;
import net.sourceforge.texlipse.texparser.node.*;

@SuppressWarnings("nls")
public class Lexer
{
    protected Token token;
    protected State state = State.NORMAL;

    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();

    @SuppressWarnings("unused")
    protected void filter() throws LexerException, IOException
    {
        // Do nothing
    }

    public Lexer(@SuppressWarnings("hiding") PushbackReader in)
    {
        this.in = in;
    }
 
    public Token peek() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.token = getToken();
            filter();
        }

        return this.token;
    }

    public Token next() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.token = getToken();
            filter();
        }

        Token result = this.token;
        this.token = null;
        return result;
    }

    protected Token getToken() throws IOException, LexerException
    {
        int dfa_state = 0;

        int start_pos = this.pos;
        int start_line = this.line;

        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_pos = -1;
        int accept_line = -1;

        @SuppressWarnings("hiding") int[][][] gotoTable = Lexer.gotoTable[this.state.id()];
        @SuppressWarnings("hiding") int[] accept = Lexer.accept[this.state.id()];
        this.text.setLength(0);

        while(true)
        {
            int c = getChar();

            if(c != -1)
            {
                switch(c)
                {
                case 10:
                    if(this.cr)
                    {
                        this.cr = false;
                    }
                    else
                    {
                        this.line++;
                        this.pos = 0;
                    }
                    break;
                case 13:
                    this.line++;
                    this.pos = 0;
                    this.cr = true;
                    break;
                default:
                    this.pos++;
                    this.cr = false;
                    break;
                }

                this.text.append((char) c);

                do
                {
                    int oldState = (dfa_state < -1) ? (-2 -dfa_state) : dfa_state;

                    dfa_state = -1;

                    int[][] tmp1 =  gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;

                    while(low <= high)
                    {
                        int middle = (low + high) / 2;
                        int[] tmp2 = tmp1[middle];

                        if(c < tmp2[0])
                        {
                            high = middle - 1;
                        }
                        else if(c > tmp2[1])
                        {
                            low = middle + 1;
                        }
                        else
                        {
                            dfa_state = tmp2[2];
                            break;
                        }
                    }
                }while(dfa_state < -1);
            }
            else
            {
                dfa_state = -1;
            }

            if(dfa_state >= 0)
            {
                if(accept[dfa_state] != -1)
                {
                    accept_state = dfa_state;
                    accept_token = accept[dfa_state];
                    accept_length = this.text.length();
                    accept_pos = this.pos;
                    accept_line = this.line;
                }
            }
            else
            {
                if(accept_state != -1)
                {
                    switch(accept_token)
                    {
                    case 0:
                        {
                            @SuppressWarnings("hiding") Token token = new0(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 2: state = State.BLOCKCAPT; break;
                                case 1: state = State.COMCAPT; break;
                                case 0: state = State.NORMAL; break;
                                case 3: state = State.OPTCAPT; break;
                                case 5: state = State.VERB; break;
                                case 4: state = State.VERBATIM; break;
                            }
                            return token;
                        }
                    case 1:
                        {
                            @SuppressWarnings("hiding") Token token = new1(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.COMCAPT; break;
                                case 0: state = State.COMCAPT; break;
                            }
                            return token;
                        }
                    case 2:
                        {
                            @SuppressWarnings("hiding") Token token = new2(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.COMCAPT; break;
                                case 0: state = State.COMCAPT; break;
                            }
                            return token;
                        }
                    case 3:
                        {
                            @SuppressWarnings("hiding") Token token = new3(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.COMCAPT; break;
                                case 0: state = State.COMCAPT; break;
                            }
                            return token;
                        }
                    case 4:
                        {
                            @SuppressWarnings("hiding") Token token = new4(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.COMCAPT; break;
                                case 0: state = State.COMCAPT; break;
                            }
                            return token;
                        }
                    case 5:
                        {
                            @SuppressWarnings("hiding") Token token = new5(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.COMCAPT; break;
                                case 0: state = State.COMCAPT; break;
                            }
                            return token;
                        }
                    case 6:
                        {
                            @SuppressWarnings("hiding") Token token = new6(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.COMCAPT; break;
                                case 0: state = State.COMCAPT; break;
                            }
                            return token;
                        }
                    case 7:
                        {
                            @SuppressWarnings("hiding") Token token = new7(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.COMCAPT; break;
                                case 0: state = State.COMCAPT; break;
                            }
                            return token;
                        }
                    case 8:
                        {
                            @SuppressWarnings("hiding") Token token = new8(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.COMCAPT; break;
                                case 0: state = State.COMCAPT; break;
                            }
                            return token;
                        }
                    case 9:
                        {
                            @SuppressWarnings("hiding") Token token = new9(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.COMCAPT; break;
                                case 0: state = State.COMCAPT; break;
                            }
                            return token;
                        }
                    case 10:
                        {
                            @SuppressWarnings("hiding") Token token = new10(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.COMCAPT; break;
                                case 0: state = State.COMCAPT; break;
                            }
                            return token;
                        }
                    case 11:
                        {
                            @SuppressWarnings("hiding") Token token = new11(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.COMCAPT; break;
                                case 0: state = State.COMCAPT; break;
                            }
                            return token;
                        }
                    case 12:
                        {
                            @SuppressWarnings("hiding") Token token = new12(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.COMCAPT; break;
                                case 0: state = State.COMCAPT; break;
                            }
                            return token;
                        }
                    case 13:
                        {
                            @SuppressWarnings("hiding") Token token = new13(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.COMCAPT; break;
                                case 0: state = State.COMCAPT; break;
                            }
                            return token;
                        }
                    case 14:
                        {
                            @SuppressWarnings("hiding") Token token = new14(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.COMCAPT; break;
                                case 0: state = State.COMCAPT; break;
                            }
                            return token;
                        }
                    case 15:
                        {
                            @SuppressWarnings("hiding") Token token = new15(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.COMCAPT; break;
                                case 0: state = State.COMCAPT; break;
                            }
                            return token;
                        }
                    case 16:
                        {
                            @SuppressWarnings("hiding") Token token = new16(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.COMCAPT; break;
                                case 0: state = State.COMCAPT; break;
                            }
                            return token;
                        }
                    case 17:
                        {
                            @SuppressWarnings("hiding") Token token = new17(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.COMCAPT; break;
                                case 0: state = State.COMCAPT; break;
                            }
                            return token;
                        }
                    case 18:
                        {
                            @SuppressWarnings("hiding") Token token = new18(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.COMCAPT; break;
                                case 0: state = State.COMCAPT; break;
                            }
                            return token;
                        }
                    case 19:
                        {
                            @SuppressWarnings("hiding") Token token = new19(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 20:
                        {
                            @SuppressWarnings("hiding") Token token = new20(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 21:
                        {
                            @SuppressWarnings("hiding") Token token = new21(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.VERBATIM; break;
                                case 0: state = State.VERBATIM; break;
                            }
                            return token;
                        }
                    case 22:
                        {
                            @SuppressWarnings("hiding") Token token = new22(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 4: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 23:
                        {
                            @SuppressWarnings("hiding") Token token = new23(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 5: state = State.VERB; break;
                                case 4: state = State.VERBATIM; break;
                            }
                            return token;
                        }
                    case 24:
                        {
                            @SuppressWarnings("hiding") Token token = new24(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.VERB; break;
                                case 0: state = State.VERB; break;
                            }
                            return token;
                        }
                    case 25:
                        {
                            @SuppressWarnings("hiding") Token token = new25(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 2: state = State.BLOCKCAPT; break;
                            }
                            return token;
                        }
                    case 26:
                        {
                            @SuppressWarnings("hiding") Token token = new26(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 3: state = State.OPTCAPT; break;
                            }
                            return token;
                        }
                    case 27:
                        {
                            @SuppressWarnings("hiding") Token token = new27(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.COMCAPT; break;
                            }
                            return token;
                        }
                    case 28:
                        {
                            @SuppressWarnings("hiding") Token token = new28(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 2: state = State.BLOCKCAPT; break;
                                case 1: state = State.BLOCKCAPT; break;
                                case 0: state = State.NORMAL; break;
                                case 3: state = State.OPTCAPT; break;
                            }
                            return token;
                        }
                    case 29:
                        {
                            @SuppressWarnings("hiding") Token token = new29(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 2: state = State.BLOCKCAPT; break;
                                case 1: state = State.NORMAL; break;
                                case 0: state = State.NORMAL; break;
                                case 3: state = State.OPTCAPT; break;
                            }
                            return token;
                        }
                    case 30:
                        {
                            @SuppressWarnings("hiding") Token token = new30(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.OPTCAPT; break;
                                case 0: state = State.NORMAL; break;
                                case 3: state = State.OPTCAPT; break;
                            }
                            return token;
                        }
                    case 31:
                        {
                            @SuppressWarnings("hiding") Token token = new31(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.NORMAL; break;
                                case 0: state = State.NORMAL; break;
                                case 3: state = State.OPTCAPT; break;
                            }
                            return token;
                        }
                    case 32:
                        {
                            @SuppressWarnings("hiding") Token token = new32(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 2: state = State.BLOCKCAPT; break;
                                case 1: state = State.COMCAPT; break;
                                case 0: state = State.COMCAPT; break;
                                case 3: state = State.OPTCAPT; break;
                            }
                            return token;
                        }
                    case 33:
                        {
                            @SuppressWarnings("hiding") Token token = new33(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 2: state = State.BLOCKCAPT; break;
                                case 1: state = State.NORMAL; break;
                                case 0: state = State.NORMAL; break;
                                case 3: state = State.OPTCAPT; break;
                            }
                            return token;
                        }
                    case 34:
                        {
                            @SuppressWarnings("hiding") Token token = new34(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 2: state = State.BLOCKCAPT; break;
                                case 1: state = State.NORMAL; break;
                                case 0: state = State.NORMAL; break;
                                case 3: state = State.OPTCAPT; break;
                            }
                            return token;
                        }
                    case 35:
                        {
                            @SuppressWarnings("hiding") Token token = new35(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.NORMAL; break;
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 36:
                        {
                            @SuppressWarnings("hiding") Token token = new36(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.COMCAPT; break;
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 37:
                        {
                            @SuppressWarnings("hiding") Token token = new37(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.COMCAPT; break;
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    case 38:
                        {
                            @SuppressWarnings("hiding") Token token = new38(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            switch(state.id())
                            {
                                case 1: state = State.COMCAPT; break;
                                case 0: state = State.NORMAL; break;
                            }
                            return token;
                        }
                    }
                }
                else
                {
                    if(this.text.length() > 0)
                    {
                        throw new LexerException(
                            "[" + (start_line + 1) + "," + (start_pos + 1) + "]" +
                            " Unknown token: " + this.text);
                    }

                    @SuppressWarnings("hiding") EOF token = new EOF(
                        start_line + 1,
                        start_pos + 1);
                    return token;
                }
            }
        }
    }

    Token new0(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TWhitespace(text, line, pos); }
    Token new1(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCpart(line, pos); }
    Token new2(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCchapter(line, pos); }
    Token new3(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCsection(line, pos); }
    Token new4(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCssection(line, pos); }
    Token new5(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCsssection(line, pos); }
    Token new6(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCparagraph(line, pos); }
    Token new7(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCbib(text, line, pos); }
    Token new8(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCbibstyle(line, pos); }
    Token new9(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TClabel(line, pos); }
    Token new10(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCref(text, line, pos); }
    Token new11(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCcite(text, line, pos); }
    Token new12(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCbegin(line, pos); }
    Token new13(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCend(line, pos); }
    Token new14(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCinput(line, pos); }
    Token new15(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCinclude(line, pos); }
    Token new16(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCnew(text, line, pos); }
    Token new17(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCrenew(line, pos); }
    Token new18(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCpackage(line, pos); }
    Token new19(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCpindex(line, pos); }
    Token new20(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCpbib(text, line, pos); }
    Token new21(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TBverbatim(text, line, pos); }
    Token new22(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TEverbatim(text, line, pos); }
    Token new23(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TVtext(text, line, pos); }
    Token new24(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCverb(text, line, pos); }
    Token new25(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TArgument(text, line, pos); }
    Token new26(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TOptargument(text, line, pos); }
    Token new27(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TStar(line, pos); }
    Token new28(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TLBrace(line, pos); }
    Token new29(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TRBrace(line, pos); }
    Token new30(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TLBracket(line, pos); }
    Token new31(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TRBracket(line, pos); }
    Token new32(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCword(text, line, pos); }
    Token new33(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCsymbol(text, line, pos); }
    Token new34(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCspace(text, line, pos); }
    Token new35(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TWord(text, line, pos); }
    Token new36(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TSkippedArea(text, line, pos); }
    Token new37(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TTaskcomment(text, line, pos); }
    Token new38(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCommentline(text, line, pos); }

    private int getChar() throws IOException
    {
        if(this.eof)
        {
            return -1;
        }

        int result = this.in.read();

        if(result == -1)
        {
            this.eof = true;
        }

        return result;
    }

    private void pushBack(int acceptLength) throws IOException
    {
        int length = this.text.length();
        for(int i = length - 1; i >= acceptLength; i--)
        {
            this.eof = false;

            this.in.unread(this.text.charAt(i));
        }
    }

    protected void unread(@SuppressWarnings("hiding") Token token) throws IOException
    {
        @SuppressWarnings("hiding") String text = token.getText();
        int length = text.length();

        for(int i = length - 1; i >= 0; i--)
        {
            this.eof = false;

            this.in.unread(text.charAt(i));
        }

        this.pos = token.getPos() - 1;
        this.line = token.getLine() - 1;
    }

    private String getText(int acceptLength)
    {
        StringBuffer s = new StringBuffer(acceptLength);
        for(int i = 0; i < acceptLength; i++)
        {
            s.append(this.text.charAt(i));
        }

        return s.toString();
    }

    private static int[][][][] gotoTable;
/*  {
        { // NORMAL
            {{0, 8, 1}, {9, 9, 2}, {10, 10, 3}, {11, 11, 1}, {12, 12, 4}, {13, 13, 5}, {14, 31, 1}, {32, 32, 6}, {33, 36, 1}, {37, 37, 7}, {38, 90, 1}, {91, 91, 8}, {92, 92, 9}, {93, 93, 10}, {94, 122, 1}, {123, 123, 11}, {124, 124, 1}, {125, 125, 12}, {126, 65535, 1}, },
            {{0, 8, 1}, {11, 12, 1}, {14, 31, 1}, {33, 90, 1}, {94, 122, 1}, {124, 124, 1}, {126, 65535, 1}, },
            {{9, 10, -2}, {12, 12, 13}, {13, 13, 5}, {32, 32, 6}, },
            {{9, 32, -4}, },
            {{0, 32, -2}, {33, 65535, -3}, },
            {{9, 9, 2}, {10, 10, 14}, {12, 32, -4}, },
            {{9, 32, -4}, },
            {{0, 8, 15}, {9, 9, 16}, {10, 10, 17}, {11, 12, 15}, {13, 13, 18}, {14, 31, 15}, {32, 32, 16}, {33, 34, 15}, {35, 35, 19}, {36, 69, 15}, {70, 70, 20}, {71, 83, 15}, {84, 84, 21}, {85, 87, 15}, {88, 88, 22}, {89, 90, 15}, {91, 93, 23}, {94, 122, 15}, {123, 123, 23}, {124, 124, 15}, {125, 125, 23}, {126, 65535, 15}, },
            {},
            {{0, 8, 24}, {9, 9, 25}, {10, 10, 26}, {11, 11, 24}, {12, 12, 27}, {13, 13, 28}, {14, 31, 24}, {32, 32, 29}, {33, 64, 24}, {65, 90, 30}, {91, 96, 24}, {97, 97, 31}, {98, 98, 32}, {99, 99, 33}, {100, 100, 30}, {101, 101, 34}, {102, 104, 30}, {105, 105, 35}, {106, 107, 30}, {108, 108, 36}, {109, 109, 30}, {110, 110, 37}, {111, 111, 30}, {112, 112, 38}, {113, 113, 30}, {114, 114, 39}, {115, 115, 40}, {116, 116, 30}, {117, 117, 41}, {118, 118, 42}, {119, 122, 30}, {123, 65535, 24}, },
            {},
            {},
            {},
            {{9, 32, -4}, },
            {{9, 32, -4}, },
            {{0, 8, 15}, {9, 9, 23}, {10, 31, -9}, {32, 32, 23}, {33, 90, 15}, {91, 65535, -9}, },
            {{0, 8, 23}, {9, 10, -9}, {11, 12, 23}, {13, 13, 18}, {14, 31, 23}, {32, 32, 16}, {33, 69, 23}, {70, 70, 43}, {71, 83, 23}, {84, 84, 44}, {85, 87, 23}, {88, 88, 45}, {89, 65535, 23}, },
            {},
            {{10, 10, 46}, },
            {{0, 32, -17}, {33, 34, 15}, {35, 35, 47}, {36, 90, 15}, {91, 65535, -9}, },
            {{0, 32, -17}, {33, 72, 15}, {73, 73, 48}, {74, 90, 15}, {91, 65535, -9}, },
            {{0, 32, -17}, {33, 78, 15}, {79, 79, 49}, {80, 90, 15}, {91, 65535, -9}, },
            {{0, 32, -17}, {33, 87, 15}, {88, 88, 50}, {89, 65535, -9}, },
            {{0, 9, 23}, {10, 13, -18}, {14, 65535, 23}, },
            {},
            {},
            {},
            {},
            {{10, 10, 51}, },
            {},
            {{65, 90, 30}, {97, 98, 30}, {99, 99, 52}, {100, 113, 30}, {114, 114, 53}, {115, 122, 30}, },
            {{65, 99, -32}, {100, 100, 54}, {101, 113, 30}, {114, 122, -32}, },
            {{65, 99, -32}, {100, 100, 30}, {101, 101, 55}, {102, 104, 30}, {105, 105, 56}, {106, 113, 30}, {114, 122, -32}, },
            {{65, 99, -32}, {100, 103, 30}, {104, 104, 57}, {105, 105, 58}, {106, 122, -34}, },
            {{65, 99, -32}, {100, 109, 30}, {110, 110, 59}, {111, 113, 30}, {114, 122, -32}, },
            {{65, 109, -36}, {110, 110, 60}, {111, 122, -36}, },
            {{65, 90, 30}, {97, 97, 61}, {98, 98, 30}, {99, 122, -32}, },
            {{65, 100, -34}, {101, 101, 62}, {102, 113, 30}, {114, 122, -32}, },
            {{65, 90, 30}, {97, 97, 63}, {98, 113, -38}, {114, 114, 64}, {115, 122, 30}, },
            {{65, 100, -34}, {101, 101, 65}, {102, 122, -39}, },
            {{65, 100, -34}, {101, 101, 66}, {102, 114, -39}, {115, 116, 30}, {117, 117, 67}, {118, 122, 30}, },
            {{65, 114, -32}, {115, 115, 68}, {116, 122, 30}, },
            {{65, 100, -34}, {101, 101, 69}, {102, 122, -39}, },
            {{0, 13, -25}, {14, 72, 23}, {73, 73, 70}, {74, 65535, 23}, },
            {{0, 13, -25}, {14, 78, 23}, {79, 79, 71}, {80, 65535, 23}, },
            {{0, 13, -25}, {14, 87, 23}, {88, 88, 72}, {89, 65535, 23}, },
            {},
            {{0, 34, -21}, {35, 35, 73}, {36, 65535, -21}, },
            {{0, 87, -24}, {88, 88, 74}, {89, 65535, -9}, },
            {{0, 32, -17}, {33, 67, 15}, {68, 68, 75}, {69, 90, 15}, {91, 65535, -9}, },
            {{0, 87, -24}, {88, 88, 76}, {89, 65535, -9}, },
            {},
            {{65, 99, -32}, {100, 104, 30}, {105, 105, 77}, {106, 122, -34}, },
            {{65, 100, -34}, {101, 101, 78}, {102, 122, -39}, },
            {{65, 99, -32}, {100, 100, 79}, {101, 122, -33}, },
            {{65, 99, -32}, {100, 102, 30}, {103, 103, 80}, {104, 113, 30}, {114, 122, -32}, },
            {{65, 90, 30}, {97, 97, 30}, {98, 98, 81}, {99, 122, -32}, },
            {{65, 90, 30}, {97, 97, 82}, {98, 122, -38}, },
            {{65, 114, -32}, {115, 115, 30}, {116, 116, 83}, {117, 122, 30}, },
            {{65, 99, -32}, {100, 100, 84}, {101, 122, -33}, },
            {{65, 98, -32}, {99, 99, 85}, {100, 111, 30}, {112, 112, 86}, {113, 113, 30}, {114, 122, -32}, },
            {{65, 97, -58}, {98, 98, 87}, {99, 122, -32}, },
            {{65, 114, -32}, {115, 118, 30}, {119, 119, 88}, {120, 120, 89}, {121, 122, 30}, },
            {{65, 113, -32}, {114, 114, 90}, {115, 122, 30}, },
            {{65, 101, -55}, {102, 104, 30}, {105, 105, 91}, {106, 110, 30}, {111, 111, 92}, {112, 113, 30}, {114, 122, -32}, },
            {{65, 99, -32}, {100, 101, 30}, {102, 102, 93}, {103, 109, 30}, {110, 110, 94}, {111, 122, -36}, },
            {{65, 98, -32}, {99, 99, 95}, {100, 122, -32}, },
            {{65, 97, -58}, {98, 98, 96}, {99, 122, -32}, },
            {{65, 100, -34}, {101, 101, 97}, {102, 122, -39}, },
            {{65, 113, -32}, {114, 114, 98}, {115, 122, 30}, },
            {{0, 87, -47}, {88, 88, 99}, {89, 65535, 23}, },
            {{0, 13, -25}, {14, 67, 23}, {68, 68, 100}, {69, 65535, 23}, },
            {{0, 87, -47}, {88, 88, 101}, {89, 65535, 23}, },
            {{0, 8, 102}, {9, 9, 103}, {10, 10, 104}, {11, 12, 102}, {13, 13, 105}, {14, 31, 102}, {32, 32, 103}, {33, 36, 102}, {37, 37, 106}, {38, 90, 102}, {91, 93, 103}, {94, 122, 102}, {123, 123, 103}, {124, 124, 102}, {125, 125, 103}, {126, 65535, 102}, },
            {{0, 32, -17}, {33, 76, 15}, {77, 77, 107}, {78, 90, 15}, {91, 65535, -9}, },
            {{0, 78, -23}, {79, 79, 108}, {80, 65535, -23}, },
            {{0, 8, 109}, {9, 9, 110}, {10, 10, 111}, {11, 12, 109}, {13, 13, 112}, {14, 31, 109}, {32, 32, 110}, {33, 90, 109}, {91, 93, 110}, {94, 122, 109}, {123, 123, 110}, {124, 124, 109}, {125, 125, 110}, {126, 65535, 109}, },
            {{65, 115, -60}, {116, 116, 113}, {117, 122, 30}, },
            {{65, 102, -67}, {103, 113, 30}, {114, 122, -32}, },
            {{65, 97, -58}, {98, 98, 114}, {99, 102, -57}, {103, 103, 115}, {104, 122, -57}, },
            {{65, 104, -54}, {105, 105, 116}, {106, 122, -34}, },
            {{65, 97, -58}, {98, 98, 117}, {99, 99, 52}, {100, 107, 30}, {108, 108, 118}, {109, 113, 30}, {114, 122, -32}, },
            {{65, 99, -32}, {100, 111, 30}, {112, 112, 119}, {113, 122, -62}, },
            {{65, 100, -34}, {101, 101, 120}, {102, 122, -39}, },
            {{65, 122, -32}, },
            {{65, 105, -54}, {106, 107, 30}, {108, 108, 121}, {109, 122, -83}, },
            {{65, 114, -32}, {115, 116, 30}, {117, 117, 122}, {118, 122, 30}, },
            {{65, 100, -34}, {101, 101, 123}, {102, 122, -39}, },
            {{65, 98, -32}, {99, 99, 124}, {100, 122, -32}, },
            {{65, 115, -60}, {116, 116, 125}, {117, 122, 30}, },
            {{65, 90, 30}, {97, 97, 126}, {98, 99, -38}, {100, 114, -55}, {115, 115, 30}, {116, 116, 127}, {117, 122, 30}, },
            {{65, 109, -36}, {110, 110, 128}, {111, 122, -36}, },
            {{65, 114, -32}, {115, 117, 30}, {118, 118, 129}, {119, 122, 30}, },
            {{65, 122, -32}, },
            {{65, 100, -34}, {101, 101, 130}, {102, 122, -39}, },
            {{65, 114, -54}, {115, 115, 30}, {116, 116, 131}, {117, 122, 30}, },
            {{65, 114, -32}, {115, 115, 132}, {116, 122, 30}, },
            {{65, 111, -84}, {112, 112, 133}, {113, 122, -62}, },
            {{65, 97, -58}, {98, 98, 134}, {99, 122, -55}, },
            {{0, 13, -25}, {14, 76, 23}, {77, 77, 135}, {78, 65535, 23}, },
            {{0, 78, -46}, {79, 79, 136}, {80, 65535, 23}, },
            {{0, 9, 110}, {10, 10, 111}, {11, 12, 110}, {13, 13, 112}, {14, 65535, 110}, },
            {{0, 65535, -75}, },
            {{0, 9, 103}, {10, 10, 104}, {11, 12, 103}, {13, 13, 105}, {14, 36, 103}, {37, 37, 137}, {38, 65535, 103}, },
            {{0, 36, 138}, {37, 37, 139}, {38, 65535, 138}, },
            {{0, 9, 138}, {10, 10, 140}, {11, 36, 138}, {37, 65535, -106}, },
            {{0, 8, 141}, {9, 9, 142}, {10, 10, 143}, {11, 12, 141}, {13, 13, 144}, {14, 31, 141}, {32, 32, 142}, {33, 34, 141}, {35, 35, 145}, {36, 36, 141}, {37, 37, 106}, {38, 90, 141}, {91, 93, 142}, {94, 122, 141}, {123, 123, 142}, {124, 124, 141}, {125, 125, 142}, {126, 65535, 141}, },
            {{0, 32, -17}, {33, 68, 15}, {69, 69, 146}, {70, 90, 15}, {91, 65535, -9}, },
            {{0, 65535, -78}, },
            {{0, 65535, -78}, },
            {{0, 65535, -103}, },
            {},
            {{10, 10, 147}, },
            {{65, 100, -34}, {101, 101, 148}, {102, 122, -39}, },
            {{65, 104, -54}, {105, 105, 149}, {106, 122, -34}, },
            {{65, 99, -32}, {100, 107, 30}, {108, 108, 150}, {109, 122, -83}, },
            {{65, 109, -36}, {110, 110, 151}, {111, 122, -36}, },
            {{65, 114, -32}, {115, 120, 30}, {121, 121, 152}, {122, 122, 30}, },
            {{65, 104, -54}, {105, 105, 153}, {106, 122, -34}, },
            {{65, 115, -60}, {116, 116, 154}, {117, 122, 30}, },
            {{65, 90, 155}, {97, 98, 155}, {99, 99, 156}, {100, 113, 155}, {114, 114, 157}, {115, 122, 155}, },
            {{65, 116, -88}, {117, 117, 158}, {118, 122, 30}, },
            {{65, 115, -60}, {116, 116, 159}, {117, 122, 30}, },
            {{65, 107, -117}, {108, 108, 160}, {109, 122, -83}, },
            {{65, 105, -54}, {106, 110, 30}, {111, 111, 161}, {112, 122, -66}, },
            {{65, 98, -32}, {99, 99, 162}, {100, 122, -32}, },
            {{65, 102, -57}, {103, 103, 163}, {104, 122, -57}, },
            {{65, 122, -32}, },
            {{65, 115, -60}, {116, 116, 164}, {117, 122, 30}, },
            {{65, 104, -54}, {105, 105, 165}, {106, 122, -34}, },
            {{65, 118, -64}, {119, 119, 166}, {120, 122, 30}, },
            {{65, 104, -54}, {105, 105, 167}, {106, 122, -34}, },
            {{65, 100, -34}, {101, 101, 168}, {102, 116, -42}, {117, 117, 169}, {118, 122, 30}, },
            {{65, 90, 30}, {97, 97, 170}, {98, 122, -38}, },
            {{42, 42, 171}, {65, 122, -32}, },
            {{0, 13, -25}, {14, 68, 23}, {69, 69, 172}, {70, 65535, 23}, },
            {{0, 65535, -103}, },
            {{0, 9, 142}, {10, 10, 143}, {11, 12, 142}, {13, 13, 144}, {14, 34, 142}, {35, 35, 173}, {36, 36, 142}, {37, 37, 137}, {38, 65535, 142}, },
            {{0, 65535, -106}, },
            {{0, 34, 174}, {35, 35, 175}, {36, 36, 174}, {37, 37, 139}, {38, 65535, 174}, },
            {{0, 65535, -106}, },
            {{0, 65535, -75}, },
            {{0, 65535, -105}, },
            {{0, 65535, -106}, },
            {{0, 65535, -107}, },
            {{0, 34, -21}, {35, 35, 176}, {36, 65535, -21}, },
            {{0, 65535, -78}, },
            {},
            {{65, 122, -32}, },
            {{65, 97, -58}, {98, 98, 177}, {99, 122, -32}, },
            {{65, 99, -32}, {100, 110, 30}, {111, 111, 178}, {112, 122, -66}, },
            {{9, 9, 179}, {10, 10, 180}, {12, 12, 181}, {13, 13, 182}, {32, 32, 183}, {65, 122, -32}, {123, 123, 184}, },
            {{65, 98, -32}, {99, 99, 185}, {100, 114, -32}, {115, 115, 186}, {116, 122, 30}, },
            {{65, 110, -152}, {111, 111, 187}, {112, 122, -66}, },
            {{65, 100, -34}, {101, 101, 188}, {102, 122, -39}, },
            {{65, 122, -122}, },
            {{65, 99, -122}, {100, 104, 155}, {105, 105, 189}, {106, 113, 155}, {114, 122, -122}, },
            {{65, 99, -122}, {100, 100, 155}, {101, 101, 190}, {102, 113, 155}, {114, 122, -122}, },
            {{65, 99, -32}, {100, 100, 191}, {101, 122, -33}, },
            {{65, 122, -32}, },
            {{65, 122, -32}, },
            {{65, 99, -32}, {100, 108, 30}, {109, 109, 192}, {110, 113, 30}, {114, 122, -32}, },
            {{65, 104, -54}, {105, 105, 193}, {106, 122, -34}, },
            {{65, 113, -32}, {114, 114, 194}, {115, 122, 30}, },
            {{65, 97, -58}, {98, 98, 195}, {99, 104, -54}, {105, 105, 196}, {106, 122, -34}, },
            {{65, 99, -32}, {100, 100, 197}, {101, 122, -33}, },
            {{65, 98, -32}, {99, 99, 198}, {100, 122, -32}, },
            {{65, 110, -152}, {111, 111, 199}, {112, 122, -66}, },
            {{65, 98, -32}, {99, 99, 200}, {100, 122, -32}, },
            {{65, 97, -58}, {98, 98, 201}, {99, 122, -32}, },
            {{65, 98, -32}, {99, 99, 202}, {100, 122, -32}, },
            {},
            {{0, 65535, -103}, },
            {{0, 13, -25}, {14, 34, 23}, {35, 35, 203}, {36, 65535, 23}, },
            {{0, 65535, -106}, },
            {{35, 35, 204}, },
            {{0, 34, -21}, {35, 35, 205}, {36, 65535, -21}, },
            {{65, 113, -32}, {114, 114, 206}, {115, 122, 30}, },
            {{65, 97, -58}, {98, 98, 207}, {99, 122, -32}, },
            {{9, 32, -153}, {123, 123, 184}, },
            {{9, 123, -181}, },
            {{9, 123, -181}, },
            {{9, 9, 179}, {10, 10, 208}, {12, 123, -181}, },
            {{9, 123, -181}, },
            {{86, 86, 209}, {108, 108, 210}, {118, 118, 211}, },
            {{65, 90, 30}, {97, 97, 212}, {98, 99, -38}, {100, 122, -54}, },
            {{65, 100, -34}, {101, 101, 213}, {102, 122, -39}, },
            {{65, 102, -57}, {103, 103, 214}, {104, 122, -57}, },
            {{65, 113, -32}, {114, 114, 215}, {115, 122, 30}, },
            {{65, 114, -122}, {115, 115, 155}, {116, 116, 216}, {117, 122, 155}, },
            {{65, 99, -122}, {100, 101, 155}, {102, 102, 217}, {103, 113, 155}, {114, 122, -122}, },
            {{65, 100, -34}, {101, 101, 218}, {102, 122, -39}, },
            {{65, 108, -163}, {109, 109, 219}, {110, 122, -163}, },
            {{65, 115, -60}, {116, 116, 220}, {117, 122, 30}, },
            {{65, 90, 30}, {97, 97, 221}, {98, 114, -92}, {115, 122, 30}, },
            {{65, 104, -54}, {105, 105, 222}, {106, 122, -34}, },
            {{65, 109, -36}, {110, 110, 223}, {111, 122, -36}, },
            {{65, 100, -34}, {101, 101, 224}, {102, 122, -39}, },
            {{65, 110, -126}, {111, 111, 225}, {112, 122, -66}, },
            {{65, 109, -36}, {110, 110, 226}, {111, 122, -36}, },
            {{65, 115, -97}, {116, 116, 227}, {117, 122, 30}, },
            {{65, 114, -32}, {115, 115, 228}, {116, 122, 30}, },
            {{65, 105, -54}, {106, 106, 30}, {107, 107, 229}, {108, 113, 30}, {114, 122, -32}, },
            {{0, 34, -175}, {35, 35, 230}, {36, 65535, 23}, },
            {{35, 35, 231}, },
            {{0, 8, 232}, {9, 9, 233}, {10, 10, 234}, {11, 12, 232}, {13, 13, 235}, {14, 31, 232}, {32, 32, 233}, {33, 90, 232}, {91, 93, 233}, {94, 122, 232}, {123, 123, 233}, {124, 124, 232}, {125, 125, 233}, {126, 65535, 232}, },
            {{65, 100, -34}, {101, 101, 236}, {102, 122, -39}, },
            {{65, 90, 30}, {97, 97, 237}, {98, 122, -38}, },
            {{9, 123, -181}, },
            {{101, 101, 238}, },
            {{115, 115, 239}, },
            {{101, 101, 240}, },
            {{65, 115, -60}, {116, 116, 241}, {117, 122, 30}, },
            {{65, 98, -32}, {99, 99, 242}, {100, 102, 30}, {103, 103, 243}, {104, 122, -57}, },
            {{65, 113, -32}, {114, 114, 244}, {115, 122, 30}, },
            {{65, 122, -55}, },
            {{65, 100, -159}, {101, 101, 245}, {102, 122, -159}, },
            {{65, 122, -122}, },
            {{65, 122, -32}, },
            {{65, 90, 30}, {97, 97, 246}, {98, 122, -38}, },
            {{65, 100, -34}, {101, 101, 247}, {102, 122, -39}, },
            {{65, 111, -84}, {112, 112, 248}, {113, 122, -62}, },
            {{65, 97, -58}, {98, 98, 249}, {99, 122, -32}, },
            {{65, 99, -32}, {100, 100, 250}, {101, 122, -33}, },
            {{65, 98, -32}, {99, 99, 251}, {100, 122, -32}, },
            {{65, 108, -163}, {109, 109, 252}, {110, 122, -163}, },
            {{65, 122, -32}, },
            {{65, 104, -54}, {105, 105, 253}, {106, 122, -34}, },
            {{65, 100, -34}, {101, 101, 254}, {102, 122, -39}, },
            {{65, 90, 30}, {97, 97, 255}, {98, 122, -38}, },
            {{0, 9, 233}, {10, 10, 234}, {11, 12, 233}, {13, 13, 235}, {14, 65535, 233}, },
            {{0, 9, 256}, {10, 10, 257}, {11, 12, 256}, {13, 13, 258}, {14, 65535, 256}, },
            {{0, 65535, -207}, },
            {{0, 65535, -232}, },
            {},
            {{10, 10, 259}, },
            {{65, 114, -80}, {115, 115, 260}, {116, 122, 30}, },
            {{65, 107, -117}, {108, 108, 261}, {109, 122, -83}, },
            {{114, 114, 262}, },
            {{116, 116, 263}, },
            {{114, 114, 264}, },
            {{65, 100, -34}, {101, 101, 265}, {102, 122, -39}, },
            {{65, 115, -97}, {116, 116, 266}, {117, 122, 30}, },
            {{65, 108, -163}, {109, 109, 267}, {110, 122, -163}, },
            {{65, 90, 30}, {97, 97, 268}, {98, 122, -196}, },
            {{65, 122, -122}, },
            {{65, 109, -36}, {110, 110, 269}, {111, 122, -36}, },
            {{65, 90, 270}, {97, 98, 270}, {99, 99, 271}, {100, 113, 270}, {114, 114, 272}, {115, 122, 270}, },
            {{65, 103, -35}, {104, 104, 273}, {105, 113, 30}, {114, 122, -32}, },
            {{65, 107, -117}, {108, 108, 274}, {109, 122, -83}, },
            {{65, 100, -34}, {101, 101, 275}, {102, 122, -39}, },
            {{65, 110, -126}, {111, 111, 276}, {112, 122, -66}, },
            {{65, 108, -163}, {109, 109, 277}, {110, 122, -163}, },
            {{65, 110, -152}, {111, 111, 278}, {112, 122, -66}, },
            {{65, 98, -32}, {99, 99, 279}, {100, 122, -32}, },
            {{65, 102, -57}, {103, 103, 280}, {104, 122, -57}, },
            {{0, 65535, -233}, },
            {},
            {{10, 10, 281}, },
            {},
            {{65, 110, -152}, {111, 111, 282}, {112, 122, -66}, },
            {{65, 97, -58}, {98, 98, 283}, {99, 122, -32}, },
            {{98, 98, 284}, },
            {{108, 108, 285}, },
            {{98, 98, 286}, },
            {{65, 102, -57}, {103, 103, 287}, {104, 122, -57}, },
            {{65, 104, -54}, {105, 105, 288}, {106, 122, -34}, },
            {{65, 100, -34}, {101, 101, 289}, {102, 122, -39}, },
            {{65, 111, -84}, {112, 112, 290}, {113, 122, -62}, },
            {{65, 99, -32}, {100, 100, 291}, {101, 122, -33}, },
            {{65, 122, -249}, },
            {{65, 99, -249}, {100, 104, 270}, {105, 105, 292}, {106, 113, 270}, {114, 122, -249}, },
            {{65, 99, -249}, {100, 100, 270}, {101, 101, 293}, {102, 113, 270}, {114, 122, -249}, },
            {{65, 122, -32}, },
            {{65, 104, -54}, {105, 105, 294}, {106, 122, -34}, },
            {{65, 114, -32}, {115, 119, 30}, {120, 120, 295}, {121, 122, 30}, },
            {{65, 108, -163}, {109, 109, 296}, {110, 122, -163}, },
            {{65, 90, 30}, {97, 97, 297}, {98, 122, -38}, },
            {{65, 109, -36}, {110, 110, 298}, {111, 122, -36}, },
            {{65, 115, -97}, {116, 116, 299}, {117, 122, 30}, },
            {{65, 100, -34}, {101, 101, 300}, {102, 122, -39}, },
            {},
            {{65, 116, -88}, {117, 117, 301}, {118, 122, 30}, },
            {{65, 104, -54}, {105, 105, 302}, {106, 122, -34}, },
            {{97, 97, 303}, },
            {{105, 105, 304}, },
            {{97, 97, 305}, },
            {{65, 110, -152}, {111, 111, 306}, {112, 122, -66}, },
            {{65, 110, -152}, {111, 111, 307}, {112, 122, -66}, },
            {{65, 109, -36}, {110, 110, 308}, {111, 122, -36}, },
            {{65, 103, -35}, {104, 104, 309}, {105, 122, -250}, },
            {{65, 122, -32}, },
            {{65, 114, -249}, {115, 115, 270}, {116, 116, 310}, {117, 122, 270}, },
            {{65, 99, -249}, {100, 101, 270}, {102, 102, 311}, {103, 113, 270}, {114, 122, -249}, },
            {{65, 110, -152}, {111, 111, 312}, {112, 122, -66}, },
            {{65, 122, -32}, },
            {{65, 108, -163}, {109, 109, 313}, {110, 122, -163}, },
            {{65, 109, -36}, {110, 110, 314}, {111, 122, -36}, },
            {{65, 122, -32}, },
            {{65, 104, -54}, {105, 105, 315}, {106, 122, -34}, },
            {{65, 122, -32}, },
            {{65, 113, -32}, {114, 114, 316}, {115, 122, 30}, },
            {{65, 97, -58}, {98, 98, 317}, {99, 122, -32}, },
            {{116, 116, 318}, },
            {{115, 115, 319}, },
            {{116, 116, 320}, },
            {{65, 113, -32}, {114, 114, 321}, {115, 122, 30}, },
            {{65, 109, -36}, {110, 110, 322}, {111, 122, -36}, },
            {{65, 115, -60}, {116, 116, 323}, {117, 122, 30}, },
            {{65, 120, -119}, {121, 121, 324}, {122, 122, 30}, },
            {{65, 100, -274}, {101, 101, 325}, {102, 122, -274}, },
            {{65, 122, -249}, },
            {{65, 102, -57}, {103, 103, 326}, {104, 122, -57}, },
            {{65, 90, 30}, {97, 97, 327}, {98, 122, -38}, },
            {{65, 99, -32}, {100, 100, 328}, {101, 122, -33}, },
            {{65, 110, -152}, {111, 111, 329}, {112, 122, -66}, },
            {{65, 98, -32}, {99, 99, 330}, {100, 122, -55}, },
            {{65, 122, -32}, },
            {{105, 105, 331}, },
            {{116, 116, 332}, },
            {{105, 105, 333}, },
            {{65, 114, -55}, {115, 120, 30}, {121, 121, 334}, {122, 122, 30}, },
            {{65, 122, -32}, },
            {{65, 122, -32}, },
            {{65, 114, -32}, {115, 115, 335}, {116, 122, 30}, },
            {{65, 122, -249}, },
            {{65, 113, -32}, {114, 114, 336}, {115, 122, 30}, },
            {{65, 109, -36}, {110, 110, 337}, {111, 122, -36}, },
            {{65, 122, -32}, },
            {{65, 109, -36}, {110, 110, 338}, {111, 122, -36}, },
            {{65, 100, -34}, {101, 101, 339}, {102, 104, 30}, {105, 122, -54}, },
            {{109, 109, 340}, },
            {{105, 105, 341}, },
            {{109, 109, 342}, },
            {{65, 122, -32}, },
            {{65, 115, -60}, {116, 116, 343}, {117, 122, 30}, },
            {{65, 90, 30}, {97, 97, 344}, {98, 122, -196}, },
            {{65, 99, -32}, {100, 100, 345}, {101, 122, -33}, },
            {{65, 122, -32}, },
            {{65, 122, -32}, },
            {{42, 42, 346}, {125, 125, 347}, },
            {{110, 110, 348}, },
            {{42, 125, -342}, },
            {{65, 120, -119}, {121, 121, 349}, {122, 122, 30}, },
            {{65, 111, -84}, {112, 112, 350}, {113, 122, -62}, },
            {{65, 122, -32}, },
            {{125, 125, 351}, },
            {},
            {{103, 103, 352}, },
            {{65, 107, -117}, {108, 108, 353}, {109, 122, -83}, },
            {{65, 103, -35}, {104, 104, 354}, {105, 122, -250}, },
            {},
            {{42, 125, -342}, },
            {{65, 100, -34}, {101, 101, 355}, {102, 122, -39}, },
            {{65, 120, -119}, {121, 121, 356}, {122, 122, 30}, },
            {{65, 122, -32}, },
            {{65, 122, -32}, },
        }
        { // COMCAPT
            {{0, 8, 1}, {9, 9, 2}, {10, 10, 3}, {11, 11, 1}, {12, 12, 4}, {13, 13, 5}, {14, 31, 1}, {32, 32, 6}, {33, 36, 1}, {37, 37, 7}, {38, 41, 1}, {42, 42, 8}, {43, 90, 1}, {91, 91, 9}, {92, 92, 10}, {93, 93, 11}, {94, 122, 1}, {123, 123, 12}, {124, 124, 1}, {125, 125, 13}, {126, 65535, 1}, },
            {{0, 8, 1}, {11, 12, 1}, {14, 31, 1}, {33, 90, 1}, {94, 122, 1}, {124, 124, 1}, {126, 65535, 1}, },
            {{9, 10, -2}, {12, 12, 14}, {13, 13, 5}, {32, 32, 6}, },
            {{9, 32, -4}, },
            {{0, 32, -2}, {33, 65535, -3}, },
            {{9, 9, 2}, {10, 10, 15}, {12, 32, -4}, },
            {{9, 32, -4}, },
            {{0, 8, 16}, {9, 9, 17}, {10, 10, 18}, {11, 12, 16}, {13, 13, 19}, {14, 31, 16}, {32, 32, 17}, {33, 34, 16}, {35, 35, 20}, {36, 69, 16}, {70, 70, 21}, {71, 83, 16}, {84, 84, 22}, {85, 87, 16}, {88, 88, 23}, {89, 90, 16}, {91, 93, 24}, {94, 122, 16}, {123, 123, 24}, {124, 124, 16}, {125, 125, 24}, {126, 65535, 16}, },
            {{0, 65535, -3}, },
            {},
            {{0, 8, 25}, {9, 9, 26}, {10, 10, 27}, {11, 11, 25}, {12, 12, 28}, {13, 13, 29}, {14, 31, 25}, {32, 32, 30}, {33, 64, 25}, {65, 90, 31}, {91, 96, 25}, {97, 97, 32}, {98, 98, 33}, {99, 99, 34}, {100, 100, 31}, {101, 101, 35}, {102, 104, 31}, {105, 105, 36}, {106, 107, 31}, {108, 108, 37}, {109, 109, 31}, {110, 110, 38}, {111, 111, 31}, {112, 112, 39}, {113, 113, 31}, {114, 114, 40}, {115, 115, 41}, {116, 116, 31}, {117, 117, 42}, {118, 118, 43}, {119, 122, 31}, {123, 65535, 25}, },
            {},
            {},
            {},
            {{9, 32, -4}, },
            {{9, 32, -4}, },
            {{0, 8, 16}, {9, 9, 24}, {10, 31, -9}, {32, 32, 24}, {33, 90, 16}, {91, 65535, -9}, },
            {{0, 8, 24}, {9, 10, -9}, {11, 12, 24}, {13, 13, 19}, {14, 31, 24}, {32, 32, 17}, {33, 69, 24}, {70, 70, 44}, {71, 83, 24}, {84, 84, 45}, {85, 87, 24}, {88, 88, 46}, {89, 65535, 24}, },
            {},
            {{10, 10, 47}, },
            {{0, 32, -18}, {33, 34, 16}, {35, 35, 48}, {36, 90, 16}, {91, 65535, -9}, },
            {{0, 32, -18}, {33, 72, 16}, {73, 73, 49}, {74, 90, 16}, {91, 65535, -9}, },
            {{0, 32, -18}, {33, 78, 16}, {79, 79, 50}, {80, 90, 16}, {91, 65535, -9}, },
            {{0, 32, -18}, {33, 87, 16}, {88, 88, 51}, {89, 65535, -9}, },
            {{0, 9, 24}, {10, 13, -19}, {14, 65535, 24}, },
            {},
            {},
            {},
            {},
            {{10, 10, 52}, },
            {},
            {{65, 90, 31}, {97, 98, 31}, {99, 99, 53}, {100, 113, 31}, {114, 114, 54}, {115, 122, 31}, },
            {{65, 99, -33}, {100, 100, 55}, {101, 113, 31}, {114, 122, -33}, },
            {{65, 99, -33}, {100, 100, 31}, {101, 101, 56}, {102, 104, 31}, {105, 105, 57}, {106, 113, 31}, {114, 122, -33}, },
            {{65, 99, -33}, {100, 103, 31}, {104, 104, 58}, {105, 105, 59}, {106, 122, -35}, },
            {{65, 99, -33}, {100, 109, 31}, {110, 110, 60}, {111, 113, 31}, {114, 122, -33}, },
            {{65, 109, -37}, {110, 110, 61}, {111, 122, -37}, },
            {{65, 90, 31}, {97, 97, 62}, {98, 98, 31}, {99, 122, -33}, },
            {{65, 100, -35}, {101, 101, 63}, {102, 113, 31}, {114, 122, -33}, },
            {{65, 90, 31}, {97, 97, 64}, {98, 113, -39}, {114, 114, 65}, {115, 122, 31}, },
            {{65, 100, -35}, {101, 101, 66}, {102, 122, -40}, },
            {{65, 100, -35}, {101, 101, 67}, {102, 114, -40}, {115, 116, 31}, {117, 117, 68}, {118, 122, 31}, },
            {{65, 114, -33}, {115, 115, 69}, {116, 122, 31}, },
            {{65, 100, -35}, {101, 101, 70}, {102, 122, -40}, },
            {{0, 13, -26}, {14, 72, 24}, {73, 73, 71}, {74, 65535, 24}, },
            {{0, 13, -26}, {14, 78, 24}, {79, 79, 72}, {80, 65535, 24}, },
            {{0, 13, -26}, {14, 87, 24}, {88, 88, 73}, {89, 65535, 24}, },
            {},
            {{0, 34, -22}, {35, 35, 74}, {36, 65535, -22}, },
            {{0, 87, -25}, {88, 88, 75}, {89, 65535, -9}, },
            {{0, 32, -18}, {33, 67, 16}, {68, 68, 76}, {69, 90, 16}, {91, 65535, -9}, },
            {{0, 87, -25}, {88, 88, 77}, {89, 65535, -9}, },
            {},
            {{65, 99, -33}, {100, 104, 31}, {105, 105, 78}, {106, 122, -35}, },
            {{65, 100, -35}, {101, 101, 79}, {102, 122, -40}, },
            {{65, 99, -33}, {100, 100, 80}, {101, 122, -34}, },
            {{65, 99, -33}, {100, 102, 31}, {103, 103, 81}, {104, 113, 31}, {114, 122, -33}, },
            {{65, 90, 31}, {97, 97, 31}, {98, 98, 82}, {99, 122, -33}, },
            {{65, 90, 31}, {97, 97, 83}, {98, 122, -39}, },
            {{65, 114, -33}, {115, 115, 31}, {116, 116, 84}, {117, 122, 31}, },
            {{65, 99, -33}, {100, 100, 85}, {101, 122, -34}, },
            {{65, 98, -33}, {99, 99, 86}, {100, 111, 31}, {112, 112, 87}, {113, 113, 31}, {114, 122, -33}, },
            {{65, 97, -59}, {98, 98, 88}, {99, 122, -33}, },
            {{65, 114, -33}, {115, 118, 31}, {119, 119, 89}, {120, 120, 90}, {121, 122, 31}, },
            {{65, 113, -33}, {114, 114, 91}, {115, 122, 31}, },
            {{65, 101, -56}, {102, 110, 31}, {111, 111, 92}, {112, 113, 31}, {114, 122, -33}, },
            {{65, 99, -33}, {100, 101, 31}, {102, 102, 93}, {103, 109, 31}, {110, 110, 94}, {111, 122, -37}, },
            {{65, 98, -33}, {99, 99, 95}, {100, 122, -33}, },
            {{65, 97, -59}, {98, 98, 96}, {99, 122, -33}, },
            {{65, 100, -35}, {101, 101, 97}, {102, 122, -40}, },
            {{65, 113, -33}, {114, 114, 98}, {115, 122, 31}, },
            {{0, 87, -48}, {88, 88, 99}, {89, 65535, 24}, },
            {{0, 13, -26}, {14, 67, 24}, {68, 68, 100}, {69, 65535, 24}, },
            {{0, 87, -48}, {88, 88, 101}, {89, 65535, 24}, },
            {{0, 8, 102}, {9, 9, 103}, {10, 10, 104}, {11, 12, 102}, {13, 13, 105}, {14, 31, 102}, {32, 32, 103}, {33, 36, 102}, {37, 37, 106}, {38, 90, 102}, {91, 93, 103}, {94, 122, 102}, {123, 123, 103}, {124, 124, 102}, {125, 125, 103}, {126, 65535, 102}, },
            {{0, 32, -18}, {33, 76, 16}, {77, 77, 107}, {78, 90, 16}, {91, 65535, -9}, },
            {{0, 78, -24}, {79, 79, 108}, {80, 65535, -24}, },
            {{0, 8, 109}, {9, 9, 110}, {10, 10, 111}, {11, 12, 109}, {13, 13, 112}, {14, 31, 109}, {32, 32, 110}, {33, 90, 109}, {91, 93, 110}, {94, 122, 109}, {123, 123, 110}, {124, 124, 109}, {125, 125, 110}, {126, 65535, 109}, },
            {{65, 115, -61}, {116, 116, 113}, {117, 122, 31}, },
            {{65, 102, -68}, {103, 113, 31}, {114, 122, -33}, },
            {{65, 97, -59}, {98, 98, 114}, {99, 102, -58}, {103, 103, 115}, {104, 122, -58}, },
            {{65, 104, -55}, {105, 105, 116}, {106, 122, -35}, },
            {{65, 99, -33}, {100, 107, 31}, {108, 108, 117}, {109, 113, 31}, {114, 122, -33}, },
            {{65, 99, -33}, {100, 111, 31}, {112, 112, 118}, {113, 122, -63}, },
            {{65, 100, -35}, {101, 101, 119}, {102, 122, -40}, },
            {{65, 122, -33}, },
            {{65, 105, -55}, {106, 107, 31}, {108, 108, 120}, {109, 122, -84}, },
            {{65, 114, -33}, {115, 116, 31}, {117, 117, 121}, {118, 122, 31}, },
            {{65, 100, -35}, {101, 101, 122}, {102, 122, -40}, },
            {{65, 98, -33}, {99, 99, 123}, {100, 122, -33}, },
            {{65, 115, -61}, {116, 116, 124}, {117, 122, 31}, },
            {{65, 90, 31}, {97, 97, 125}, {98, 99, -39}, {100, 114, -56}, {115, 115, 31}, {116, 116, 126}, {117, 122, 31}, },
            {{65, 114, -33}, {115, 117, 31}, {118, 118, 127}, {119, 122, 31}, },
            {{65, 122, -33}, },
            {{65, 100, -35}, {101, 101, 128}, {102, 122, -40}, },
            {{65, 114, -55}, {115, 115, 31}, {116, 116, 129}, {117, 122, 31}, },
            {{65, 114, -33}, {115, 115, 130}, {116, 122, 31}, },
            {{65, 111, -85}, {112, 112, 131}, {113, 122, -63}, },
            {{65, 97, -59}, {98, 98, 132}, {99, 122, -56}, },
            {{0, 13, -26}, {14, 76, 24}, {77, 77, 133}, {78, 65535, 24}, },
            {{0, 78, -47}, {79, 79, 134}, {80, 65535, 24}, },
            {{0, 9, 110}, {10, 10, 111}, {11, 12, 110}, {13, 13, 112}, {14, 65535, 110}, },
            {{0, 65535, -76}, },
            {{0, 9, 103}, {10, 10, 104}, {11, 12, 103}, {13, 13, 105}, {14, 36, 103}, {37, 37, 135}, {38, 65535, 103}, },
            {{0, 36, 136}, {37, 37, 137}, {38, 65535, 136}, },
            {{0, 9, 136}, {10, 10, 138}, {11, 36, 136}, {37, 65535, -106}, },
            {{0, 8, 139}, {9, 9, 140}, {10, 10, 141}, {11, 12, 139}, {13, 13, 142}, {14, 31, 139}, {32, 32, 140}, {33, 34, 139}, {35, 35, 143}, {36, 36, 139}, {37, 37, 106}, {38, 90, 139}, {91, 93, 140}, {94, 122, 139}, {123, 123, 140}, {124, 124, 139}, {125, 125, 140}, {126, 65535, 139}, },
            {{0, 32, -18}, {33, 68, 16}, {69, 69, 144}, {70, 90, 16}, {91, 65535, -9}, },
            {{0, 65535, -79}, },
            {{0, 65535, -79}, },
            {{0, 65535, -103}, },
            {},
            {{10, 10, 145}, },
            {{65, 100, -35}, {101, 101, 146}, {102, 122, -40}, },
            {{65, 104, -55}, {105, 105, 147}, {106, 122, -35}, },
            {{65, 107, -84}, {108, 108, 148}, {109, 122, -84}, },
            {{65, 109, -37}, {110, 110, 149}, {111, 122, -37}, },
            {{65, 104, -55}, {105, 105, 150}, {106, 122, -35}, },
            {{65, 115, -61}, {116, 116, 151}, {117, 122, 31}, },
            {{65, 90, 152}, {97, 98, 152}, {99, 99, 153}, {100, 113, 152}, {114, 114, 154}, {115, 122, 152}, },
            {{65, 116, -89}, {117, 117, 155}, {118, 122, 31}, },
            {{65, 115, -61}, {116, 116, 156}, {117, 122, 31}, },
            {{65, 107, -84}, {108, 108, 157}, {109, 122, -84}, },
            {{65, 105, -55}, {106, 110, 31}, {111, 111, 158}, {112, 122, -67}, },
            {{65, 98, -33}, {99, 99, 159}, {100, 122, -33}, },
            {{65, 102, -58}, {103, 103, 160}, {104, 122, -58}, },
            {{65, 122, -33}, },
            {{65, 104, -55}, {105, 105, 161}, {106, 122, -35}, },
            {{65, 118, -65}, {119, 119, 162}, {120, 122, 31}, },
            {{65, 104, -55}, {105, 105, 163}, {106, 122, -35}, },
            {{65, 100, -35}, {101, 101, 164}, {102, 116, -43}, {117, 117, 165}, {118, 122, 31}, },
            {{65, 90, 31}, {97, 97, 166}, {98, 122, -39}, },
            {{42, 42, 167}, {65, 122, -33}, },
            {{0, 13, -26}, {14, 68, 24}, {69, 69, 168}, {70, 65535, 24}, },
            {{0, 65535, -103}, },
            {{0, 9, 140}, {10, 10, 141}, {11, 12, 140}, {13, 13, 142}, {14, 34, 140}, {35, 35, 169}, {36, 36, 140}, {37, 37, 135}, {38, 65535, 140}, },
            {{0, 65535, -106}, },
            {{0, 34, 170}, {35, 35, 171}, {36, 36, 170}, {37, 37, 137}, {38, 65535, 170}, },
            {{0, 65535, -106}, },
            {{0, 65535, -76}, },
            {{0, 65535, -105}, },
            {{0, 65535, -106}, },
            {{0, 65535, -107}, },
            {{0, 34, -22}, {35, 35, 172}, {36, 65535, -22}, },
            {{0, 65535, -79}, },
            {},
            {{65, 122, -33}, },
            {{65, 97, -59}, {98, 98, 173}, {99, 122, -33}, },
            {{65, 99, -33}, {100, 110, 31}, {111, 111, 174}, {112, 122, -67}, },
            {{9, 9, 175}, {10, 10, 176}, {12, 12, 177}, {13, 13, 178}, {32, 32, 179}, {65, 122, -33}, {123, 123, 180}, },
            {{65, 110, -150}, {111, 111, 181}, {112, 122, -67}, },
            {{65, 100, -35}, {101, 101, 182}, {102, 122, -40}, },
            {{65, 122, -121}, },
            {{65, 99, -121}, {100, 104, 152}, {105, 105, 183}, {106, 113, 152}, {114, 122, -121}, },
            {{65, 99, -121}, {100, 100, 152}, {101, 101, 184}, {102, 113, 152}, {114, 122, -121}, },
            {{65, 99, -33}, {100, 100, 185}, {101, 122, -34}, },
            {{65, 122, -33}, },
            {{65, 122, -33}, },
            {{65, 99, -33}, {100, 108, 31}, {109, 109, 186}, {110, 113, 31}, {114, 122, -33}, },
            {{65, 104, -55}, {105, 105, 187}, {106, 122, -35}, },
            {{65, 113, -33}, {114, 114, 188}, {115, 122, 31}, },
            {{65, 99, -33}, {100, 100, 189}, {101, 122, -34}, },
            {{65, 98, -33}, {99, 99, 190}, {100, 122, -33}, },
            {{65, 110, -150}, {111, 111, 191}, {112, 122, -67}, },
            {{65, 98, -33}, {99, 99, 192}, {100, 122, -33}, },
            {{65, 97, -59}, {98, 98, 193}, {99, 122, -33}, },
            {{65, 98, -33}, {99, 99, 194}, {100, 122, -33}, },
            {},
            {{0, 65535, -103}, },
            {{0, 13, -26}, {14, 34, 24}, {35, 35, 195}, {36, 65535, 24}, },
            {{0, 65535, -106}, },
            {{35, 35, 196}, },
            {{0, 34, -22}, {35, 35, 197}, {36, 65535, -22}, },
            {{65, 113, -33}, {114, 114, 198}, {115, 122, 31}, },
            {{65, 97, -59}, {98, 98, 199}, {99, 122, -33}, },
            {{9, 32, -151}, {123, 123, 180}, },
            {{9, 123, -177}, },
            {{9, 123, -177}, },
            {{9, 9, 175}, {10, 10, 200}, {12, 123, -177}, },
            {{9, 123, -177}, },
            {{86, 86, 201}, {108, 108, 202}, {118, 118, 203}, },
            {{65, 102, -58}, {103, 103, 204}, {104, 122, -58}, },
            {{65, 113, -33}, {114, 114, 205}, {115, 122, 31}, },
            {{65, 114, -121}, {115, 115, 152}, {116, 116, 206}, {117, 122, 152}, },
            {{65, 99, -121}, {100, 101, 152}, {102, 102, 207}, {103, 113, 152}, {114, 122, -121}, },
            {{65, 100, -35}, {101, 101, 208}, {102, 122, -40}, },
            {{65, 108, -160}, {109, 109, 209}, {110, 122, -160}, },
            {{65, 115, -61}, {116, 116, 210}, {117, 122, 31}, },
            {{65, 90, 31}, {97, 97, 211}, {98, 114, -93}, {115, 122, 31}, },
            {{65, 100, -35}, {101, 101, 212}, {102, 122, -40}, },
            {{65, 110, -125}, {111, 111, 213}, {112, 122, -67}, },
            {{65, 109, -37}, {110, 110, 214}, {111, 122, -37}, },
            {{65, 115, -97}, {116, 116, 215}, {117, 122, 31}, },
            {{65, 114, -33}, {115, 115, 216}, {116, 122, 31}, },
            {{65, 105, -55}, {106, 106, 31}, {107, 107, 217}, {108, 113, 31}, {114, 122, -33}, },
            {{0, 34, -171}, {35, 35, 218}, {36, 65535, 24}, },
            {{35, 35, 219}, },
            {{0, 8, 220}, {9, 9, 221}, {10, 10, 222}, {11, 12, 220}, {13, 13, 223}, {14, 31, 220}, {32, 32, 221}, {33, 90, 220}, {91, 93, 221}, {94, 122, 220}, {123, 123, 221}, {124, 124, 220}, {125, 125, 221}, {126, 65535, 220}, },
            {{65, 100, -35}, {101, 101, 224}, {102, 122, -40}, },
            {{65, 90, 31}, {97, 97, 225}, {98, 122, -39}, },
            {{9, 123, -177}, },
            {{101, 101, 226}, },
            {{115, 115, 227}, },
            {{101, 101, 228}, },
            {{65, 113, -33}, {114, 114, 229}, {115, 122, 31}, },
            {{65, 122, -56}, },
            {{65, 100, -156}, {101, 101, 230}, {102, 122, -156}, },
            {{65, 122, -121}, },
            {{65, 122, -33}, },
            {{65, 90, 31}, {97, 97, 231}, {98, 122, -39}, },
            {{65, 100, -35}, {101, 101, 232}, {102, 122, -40}, },
            {{65, 111, -85}, {112, 112, 233}, {113, 122, -63}, },
            {{65, 98, -33}, {99, 99, 234}, {100, 122, -33}, },
            {{65, 108, -160}, {109, 109, 235}, {110, 122, -160}, },
            {{65, 122, -33}, },
            {{65, 104, -55}, {105, 105, 236}, {106, 122, -35}, },
            {{65, 100, -35}, {101, 101, 237}, {102, 122, -40}, },
            {{65, 90, 31}, {97, 97, 238}, {98, 122, -39}, },
            {{0, 9, 221}, {10, 10, 222}, {11, 12, 221}, {13, 13, 223}, {14, 65535, 221}, },
            {{0, 9, 239}, {10, 10, 240}, {11, 12, 239}, {13, 13, 241}, {14, 65535, 239}, },
            {{0, 65535, -199}, },
            {{0, 65535, -220}, },
            {},
            {{10, 10, 242}, },
            {{65, 114, -81}, {115, 115, 243}, {116, 122, 31}, },
            {{65, 107, -84}, {108, 108, 244}, {109, 122, -84}, },
            {{114, 114, 245}, },
            {{116, 116, 246}, },
            {{114, 114, 247}, },
            {{65, 90, 31}, {97, 97, 248}, {98, 122, -190}, },
            {{65, 122, -121}, },
            {{65, 109, -37}, {110, 110, 249}, {111, 122, -37}, },
            {{65, 90, 250}, {97, 98, 250}, {99, 99, 251}, {100, 113, 250}, {114, 114, 252}, {115, 122, 250}, },
            {{65, 103, -36}, {104, 104, 253}, {105, 113, 31}, {114, 122, -33}, },
            {{65, 110, -125}, {111, 111, 254}, {112, 122, -67}, },
            {{65, 108, -160}, {109, 109, 255}, {110, 122, -160}, },
            {{65, 110, -150}, {111, 111, 256}, {112, 122, -67}, },
            {{65, 98, -33}, {99, 99, 257}, {100, 122, -33}, },
            {{65, 102, -58}, {103, 103, 258}, {104, 122, -58}, },
            {{0, 65535, -221}, },
            {},
            {{10, 10, 259}, },
            {},
            {{65, 110, -150}, {111, 111, 260}, {112, 122, -67}, },
            {{65, 97, -59}, {98, 98, 261}, {99, 122, -33}, },
            {{98, 98, 262}, },
            {{108, 108, 263}, },
            {{98, 98, 264}, },
            {{65, 111, -85}, {112, 112, 265}, {113, 122, -63}, },
            {{65, 99, -33}, {100, 100, 266}, {101, 122, -34}, },
            {{65, 122, -234}, },
            {{65, 99, -234}, {100, 104, 250}, {105, 105, 267}, {106, 113, 250}, {114, 122, -234}, },
            {{65, 99, -234}, {100, 100, 250}, {101, 101, 268}, {102, 113, 250}, {114, 122, -234}, },
            {{65, 122, -33}, },
            {{65, 108, -160}, {109, 109, 269}, {110, 122, -160}, },
            {{65, 90, 31}, {97, 97, 270}, {98, 122, -39}, },
            {{65, 109, -37}, {110, 110, 271}, {111, 122, -37}, },
            {{65, 115, -97}, {116, 116, 272}, {117, 122, 31}, },
            {{65, 100, -35}, {101, 101, 273}, {102, 122, -40}, },
            {},
            {{65, 116, -89}, {117, 117, 274}, {118, 122, 31}, },
            {{65, 104, -55}, {105, 105, 275}, {106, 122, -35}, },
            {{97, 97, 276}, },
            {{105, 105, 277}, },
            {{97, 97, 278}, },
            {{65, 103, -36}, {104, 104, 279}, {105, 122, -235}, },
            {{65, 122, -33}, },
            {{65, 114, -234}, {115, 115, 250}, {116, 116, 280}, {117, 122, 250}, },
            {{65, 99, -234}, {100, 101, 250}, {102, 102, 281}, {103, 113, 250}, {114, 122, -234}, },
            {{65, 108, -160}, {109, 109, 282}, {110, 122, -160}, },
            {{65, 109, -37}, {110, 110, 283}, {111, 122, -37}, },
            {{65, 122, -33}, },
            {{65, 104, -55}, {105, 105, 284}, {106, 122, -35}, },
            {{65, 122, -33}, },
            {{65, 113, -33}, {114, 114, 285}, {115, 122, 31}, },
            {{65, 97, -59}, {98, 98, 286}, {99, 122, -33}, },
            {{116, 116, 287}, },
            {{115, 115, 288}, },
            {{116, 116, 289}, },
            {{65, 114, -33}, {115, 120, 31}, {121, 121, 290}, {122, 122, 31}, },
            {{65, 100, -254}, {101, 101, 291}, {102, 122, -254}, },
            {{65, 122, -234}, },
            {{65, 90, 31}, {97, 97, 292}, {98, 122, -39}, },
            {{65, 99, -33}, {100, 100, 293}, {101, 122, -34}, },
            {{65, 110, -150}, {111, 111, 294}, {112, 122, -67}, },
            {{65, 98, -33}, {99, 99, 295}, {100, 122, -56}, },
            {{65, 122, -33}, },
            {{105, 105, 296}, },
            {{116, 116, 297}, },
            {{105, 105, 298}, },
            {{65, 114, -33}, {115, 115, 299}, {116, 122, 31}, },
            {{65, 122, -234}, },
            {{65, 109, -37}, {110, 110, 300}, {111, 122, -37}, },
            {{65, 122, -33}, },
            {{65, 109, -37}, {110, 110, 301}, {111, 122, -37}, },
            {{65, 100, -35}, {101, 101, 302}, {102, 104, 31}, {105, 122, -55}, },
            {{109, 109, 303}, },
            {{105, 105, 304}, },
            {{109, 109, 305}, },
            {{65, 115, -61}, {116, 116, 306}, {117, 122, 31}, },
            {{65, 99, -33}, {100, 100, 307}, {101, 122, -34}, },
            {{65, 122, -33}, },
            {{65, 122, -33}, },
            {{42, 42, 308}, {125, 125, 309}, },
            {{110, 110, 310}, },
            {{42, 125, -305}, },
            {{65, 120, -281}, {121, 121, 311}, {122, 122, 31}, },
            {{65, 122, -33}, },
            {{125, 125, 312}, },
            {},
            {{103, 103, 313}, },
            {{65, 107, -84}, {108, 108, 314}, {109, 122, -84}, },
            {},
            {{42, 125, -305}, },
            {{65, 100, -35}, {101, 101, 315}, {102, 122, -40}, },
            {{65, 122, -33}, },
        }
        { // BLOCKCAPT
            {{0, 8, 1}, {9, 9, 2}, {10, 10, 3}, {11, 11, 1}, {12, 12, 4}, {13, 13, 5}, {14, 31, 1}, {32, 32, 6}, {33, 91, 1}, {92, 92, 7}, {93, 122, 1}, {123, 123, 8}, {124, 124, 1}, {125, 125, 9}, {126, 65535, 1}, },
            {{0, 8, 1}, {11, 12, 1}, {14, 31, 1}, {33, 91, 1}, {93, 122, 1}, {124, 124, 1}, {126, 65535, 1}, },
            {{9, 10, -2}, {12, 12, 10}, {13, 13, 5}, {32, 32, 6}, },
            {{9, 32, -4}, },
            {{0, 91, -2}, {93, 65535, -3}, },
            {{9, 9, 2}, {10, 10, 11}, {12, 32, -4}, },
            {{9, 32, -4}, },
            {{0, 8, 12}, {9, 9, 13}, {10, 10, 14}, {11, 11, 12}, {12, 12, 15}, {13, 13, 16}, {14, 31, 12}, {32, 32, 17}, {33, 64, 12}, {65, 90, 18}, {91, 96, 12}, {97, 122, 18}, {123, 65535, 12}, },
            {},
            {},
            {{9, 32, -4}, },
            {{9, 32, -4}, },
            {},
            {},
            {},
            {},
            {{10, 10, 19}, },
            {},
            {{65, 90, 18}, {97, 122, 18}, },
            {},
        }
        { // OPTCAPT
            {{0, 8, 1}, {9, 9, 2}, {10, 10, 3}, {11, 11, 1}, {12, 12, 4}, {13, 13, 5}, {14, 31, 1}, {32, 32, 6}, {33, 90, 1}, {91, 91, 7}, {92, 92, 8}, {93, 93, 9}, {94, 122, 1}, {123, 123, 10}, {124, 124, 1}, {125, 125, 11}, {126, 65535, 1}, },
            {{0, 8, 1}, {11, 12, 1}, {14, 31, 1}, {33, 90, 1}, {94, 122, 1}, {124, 124, 1}, {126, 65535, 1}, },
            {{9, 10, -2}, {12, 12, 12}, {13, 13, 5}, {32, 32, 6}, },
            {{9, 32, -4}, },
            {{0, 90, -2}, {94, 65535, -3}, },
            {{9, 9, 2}, {10, 10, 13}, {12, 32, -4}, },
            {{9, 32, -4}, },
            {},
            {{0, 8, 14}, {9, 9, 15}, {10, 10, 16}, {11, 11, 14}, {12, 12, 17}, {13, 13, 18}, {14, 31, 14}, {32, 32, 19}, {33, 64, 14}, {65, 90, 20}, {91, 96, 14}, {97, 122, 20}, {123, 65535, 14}, },
            {},
            {},
            {},
            {{9, 32, -4}, },
            {{9, 32, -4}, },
            {},
            {},
            {},
            {},
            {{10, 10, 21}, },
            {},
            {{65, 90, 20}, {97, 122, 20}, },
            {},
        }
        { // VERBATIM
            {{0, 8, 1}, {9, 9, 2}, {10, 10, 3}, {11, 11, 1}, {12, 12, 4}, {13, 13, 5}, {14, 31, 1}, {32, 32, 6}, {33, 91, 1}, {92, 92, 7}, {93, 65535, 1}, },
            {},
            {{9, 10, -2}, {12, 12, 8}, {13, 13, 5}, {32, 32, 6}, },
            {{9, 32, -4}, },
            {{9, 32, -4}, },
            {{9, 9, 2}, {10, 10, 9}, {12, 32, -4}, },
            {{9, 32, -4}, },
            {{101, 101, 10}, },
            {{9, 32, -4}, },
            {{9, 32, -4}, },
            {{110, 110, 11}, },
            {{100, 100, 12}, },
            {{123, 123, 13}, },
            {{86, 86, 14}, {108, 108, 15}, {118, 118, 16}, },
            {{101, 101, 17}, },
            {{115, 115, 18}, },
            {{101, 101, 19}, },
            {{114, 114, 20}, },
            {{116, 116, 21}, },
            {{114, 114, 22}, },
            {{98, 98, 23}, },
            {{108, 108, 24}, },
            {{98, 98, 25}, },
            {{97, 97, 26}, },
            {{105, 105, 27}, },
            {{97, 97, 28}, },
            {{116, 116, 29}, },
            {{115, 115, 30}, },
            {{116, 116, 31}, },
            {{105, 105, 32}, },
            {{116, 116, 33}, },
            {{105, 105, 34}, },
            {{109, 109, 35}, },
            {{105, 105, 36}, },
            {{109, 109, 37}, },
            {{42, 42, 38}, {125, 125, 39}, },
            {{110, 110, 40}, },
            {{42, 125, -37}, },
            {{125, 125, 41}, },
            {},
            {{103, 103, 42}, },
            {},
            {{42, 125, -37}, },
        }
        { // VERB
            {{0, 8, 1}, {9, 9, 2}, {10, 10, 3}, {11, 11, 1}, {12, 12, 4}, {13, 13, 5}, {14, 31, 1}, {32, 32, 6}, {33, 65535, 1}, },
            {},
            {{9, 10, -2}, {12, 12, 7}, {13, 13, 5}, {32, 32, 6}, },
            {{9, 32, -4}, },
            {{9, 32, -4}, },
            {{9, 9, 2}, {10, 10, 8}, {12, 32, -4}, },
            {{9, 32, -4}, },
            {{9, 32, -4}, },
            {{9, 32, -4}, },
        }
    };*/

    private static int[][] accept;
/*  {
        // NORMAL
        {-1, 35, 0, 0, 0, 0, 0, 35, 30, -1, 31, 28, 29, 0, 0, 35, 38, 38, 38, 35, 35, 35, 35, 38, 33, 34, 34, 33, 34, 34, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 38, 38, 38, 38, 35, 35, 35, 35, 34, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 38, 38, 38, 35, 35, 35, 35, 32, 32, 32, 32, 32, 32, 32, 13, 32, 32, 32, 32, 32, 32, 32, 32, 10, 32, 32, 32, 32, 32, 38, 38, 37, 35, 38, 38, 38, 35, 35, 35, 35, 37, 37, 37, 32, 32, 32, 32, 32, 32, 32, 11, 32, 32, 32, 32, 32, 32, 1, 32, 32, 32, 32, 32, 32, 24, 38, 37, 38, -1, -1, 38, 35, 38, 38, 38, 35, 35, 37, 11, 32, 32, 12, 32, 32, 32, 11, 11, 11, 32, 14, 9, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 24, 37, 38, -1, -1, 35, 32, 32, -1, -1, -1, -1, -1, -1, 32, 32, 32, 32, 11, 11, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 38, -1, 35, 32, 32, -1, -1, -1, -1, 32, 32, 32, 2, 11, 10, 15, 32, 32, 32, 32, 32, 32, 32, 3, 32, 32, 32, 36, 36, 35, 36, 36, 36, 32, 32, -1, -1, -1, 32, 32, 32, 32, 11, 32, 11, 32, 32, 32, 32, 32, 32, 32, 32, 36, 36, 36, 36, 32, 32, -1, -1, -1, 32, 32, 32, 32, 32, 11, 11, 11, 6, 32, 32, 32, 32, 32, 32, 32, 36, 32, 32, -1, -1, -1, 32, 32, 32, 32, 16, 11, 11, 32, 19, 32, 32, 4, 32, 18, 32, 32, -1, -1, -1, 32, 32, 32, 32, 11, 10, 32, 32, 32, 32, 32, 7, -1, -1, -1, 32, 20, 20, 7, 11, 32, 32, 17, 32, 32, -1, -1, -1, 20, 32, 32, 32, 5, 7, -1, -1, -1, 32, 32, 16, -1, 21, -1, 32, 32, 21, -1, 32, 32, 8, 20, },
        // COMCAPT
        {-1, 35, 0, 0, 0, 0, 0, 35, 27, 30, -1, 31, 28, 29, 0, 0, 35, 38, 38, 38, 35, 35, 35, 35, 38, 33, 34, 34, 33, 34, 34, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 38, 38, 38, 38, 35, 35, 35, 35, 34, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 38, 38, 38, 35, 35, 35, 35, 32, 32, 32, 32, 32, 32, 32, 13, 32, 32, 32, 32, 32, 32, 32, 10, 32, 32, 32, 32, 32, 38, 38, 37, 35, 38, 38, 38, 35, 35, 35, 35, 37, 37, 37, 32, 32, 32, 32, 32, 32, 11, 32, 32, 32, 32, 32, 32, 1, 32, 32, 32, 32, 32, 24, 38, 37, 38, -1, -1, 38, 35, 38, 38, 38, 35, 35, 37, 11, 32, 32, 12, 32, 32, 11, 11, 11, 32, 14, 9, 32, 32, 32, 32, 32, 32, 32, 32, 32, 24, 37, 38, -1, -1, 35, 32, 32, -1, -1, -1, -1, -1, -1, 32, 32, 11, 11, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 38, -1, 35, 32, 32, -1, -1, -1, -1, 32, 2, 11, 10, 15, 32, 32, 32, 32, 32, 3, 32, 32, 32, 36, 36, 35, 36, 36, 36, 32, 32, -1, -1, -1, 32, 11, 32, 11, 32, 32, 32, 32, 32, 32, 36, 36, 36, 36, 32, 32, -1, -1, -1, 32, 32, 11, 11, 11, 6, 32, 32, 32, 32, 32, 36, 32, 32, -1, -1, -1, 32, 16, 11, 11, 32, 32, 4, 32, 18, 32, 32, -1, -1, -1, 32, 11, 10, 32, 32, 32, 32, 7, -1, -1, -1, 7, 11, 32, 17, 32, 32, -1, -1, -1, 32, 32, 5, 7, -1, -1, -1, 32, 16, -1, 21, -1, 32, 21, -1, 32, 8, },
        // BLOCKCAPT
        {-1, 25, 0, 0, 0, 0, 0, -1, 28, 29, 0, 0, 33, 34, 34, 33, 34, 34, 32, 34, },
        // OPTCAPT
        {-1, 26, 0, 0, 0, 0, 0, 30, -1, 31, 28, 29, 0, 0, 33, 34, 34, 33, 34, 34, 32, 34, },
        // VERBATIM
        {-1, 23, 0, 0, 0, 0, 0, 23, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 22, -1, 22, -1, },
        // VERB
        {-1, 23, 0, 0, 0, 0, 0, 0, 0, },

    };*/

    public static class State
    {
        public final static State NORMAL = new State(0);
        public final static State COMCAPT = new State(1);
        public final static State BLOCKCAPT = new State(2);
        public final static State OPTCAPT = new State(3);
        public final static State VERBATIM = new State(4);
        public final static State VERB = new State(5);

        private int id;

        private State(@SuppressWarnings("hiding") int id)
        {
            this.id = id;
        }

        public int id()
        {
            return this.id;
        }
    }

    static 
    {
        try
        {
            DataInputStream s = new DataInputStream(
                new BufferedInputStream(
                Lexer.class.getResourceAsStream("lexer.dat")));

            // read gotoTable
            int length = s.readInt();
            gotoTable = new int[length][][][];
            for(int i = 0; i < gotoTable.length; i++)
            {
                length = s.readInt();
                gotoTable[i] = new int[length][][];
                for(int j = 0; j < gotoTable[i].length; j++)
                {
                    length = s.readInt();
                    gotoTable[i][j] = new int[length][3];
                    for(int k = 0; k < gotoTable[i][j].length; k++)
                    {
                        for(int l = 0; l < 3; l++)
                        {
                            gotoTable[i][j][k][l] = s.readInt();
                        }
                    }
                }
            }

            // read accept
            length = s.readInt();
            accept = new int[length][];
            for(int i = 0; i < accept.length; i++)
            {
                length = s.readInt();
                accept[i] = new int[length];
                for(int j = 0; j < accept[i].length; j++)
                {
                    accept[i][j] = s.readInt();
                }
            }

            s.close();
        }
        catch(Exception e)
        {
            throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
        }
    }
}
