//
// Latex Project Public Licence (lppl1.3) applies
// Originally written by Kwanleung Tse
// First Release : 1st July, 2014
// Last Update : 25th September, 2014
//
//

package worker4math.hktex2;

import java.util.ArrayList;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.util.SparseArray;
import android.util.SparseBooleanArray;


public class Parsetext {
	
		public static volatile SparseArray<Float> thisypos = new SparseArray<Float>();
		public static volatile SparseBooleanArray error = new SparseBooleanArray();
		public static volatile SparseArray<String> errormessage = new SparseArray<String>();
        
	    public void parsetext(Canvas canvas, Block block, ParagraphBlock paragraphblock, Integer tid, Integer containerwidth, Integer containerheight, int superblocknumber, SuperBlock superblock, String line,
	    	    float referencex, float referencey, 
	    		ArrayList<Typeface> tf ,String attribute0, String attribute1, Boolean dohyphenation, float indent){

	    	float pagewidth = containerwidth-Header.rightsidemargin-Header.leftsidemargin;
            float maxheight = 0.0f;
		    float maxdepth = 0.0f;
            
	    	int i,ii;
		    int nummolecule = 0;
		    int fontsize = Integer.parseInt(attribute0.substring(1,4));
		    
		    error.put(tid,false);
		    errormessage.put(tid,"");
			
            Boolean newline=false;
            
		    String molecule = "";

			Paint textpaint = new Paint();
		    Rect textbounds = new Rect();
			textpaint.setTextSize(Integer.parseInt(attribute0.substring(1,4)));
			textpaint.setTypeface(tf.get(Integer.parseInt(attribute0.substring(4,7))));
			textpaint.getTextBounds("Aj",0,"Aj".length(),textbounds);							  
	    	referencey=referencey+textbounds.height()-textbounds.bottom;	    	
		    Float sizeofblank=textpaint.measureText(" ");

            Separatetext line2superblock = new Separatetext();
 
            line2superblock = new Separatetext();
            line2superblock.separatetext(line);
            nummolecule = line2superblock.nummolecule;	             
	                  
            Float blockheight = 0.0f;
            Float blockwidth = 0.0f;
            Float blockdepth = 0.0f;
            ArrayList<String> subblock = new ArrayList<String>();
            ArrayList<Float> subblockxpos = new ArrayList<Float>();
            ArrayList<Float> subblockypos = new ArrayList<Float>();    	
            ArrayList<String> subblockattribute = new ArrayList<String>(); 
		    		    
            maxheight = 0.0f;
            maxdepth = 0.0f;
            synchronized(this){superblock.create(tid);}
	            	 
            for (ii=0;ii<=nummolecule-1;ii++){                         // First parse
            	molecule = line2superblock.molecule.get(ii);
            	if (ii==0) {molecule=molecule.trim(); 
            	if (molecule.length()>=9 && molecule.substring(0,9).equals("!noindent")){indent = 0; molecule=molecule.substring(9); molecule=molecule.trim();}}
	                      
            	if (!line2superblock.text.get(ii)){
            		Parsepreparation newmolecule = new Parsepreparation();
            		molecule=newmolecule.parsepreparation(molecule,Symbol.symboltype,Symbol.matchsymbol);	  

            		Parseblock superblock2block = new Parseblock();
            		molecule=molecule.trim();

            		superblock2block.parseblock(tid,canvas, block, molecule,tf,attribute1);
            		if (Block.error.get(tid)==true){error.put(tid, true); errormessage.put(tid, Block.errormessage.get(tid)); return;};
            		blockheight=Block.blockheight2.get(tid);
            		blockwidth=Block.blockwidth2.get(tid);
            		blockdepth=Block.blockdepth2.get(tid);
            		maxheight = Math.max(maxheight,Block.blockheight2.get(tid) );
            		maxdepth = Math.max(maxdepth, Block.blockdepth2.get(tid));
            		int numatom=Block.subblock2.get(tid).size();
            		for (i=0;i<=numatom-1;i++){
            			Block.subblockxpos2.get(tid).set(i,Block.subblockxpos2.get(tid).get(i)+referencex+indent);		 		            		  
            			Block.subblockypos2.get(tid).set(i,Block.subblockypos2.get(tid).get(i)+referencey);		            		  
            			subblock.add(Block.subblock2.get(tid).get(i));
            			subblockxpos.add(Block.subblockxpos2.get(tid).get(i));
            			subblockypos.add(Block.subblockypos2.get(tid).get(i));   
            			subblockattribute.add(Block.subblockattribute2.get(tid).get(i));	
            		} 
            		synchronized(this){
            			if (newline && SuperBlock.blockatom.get(tid*1000+SuperBlock.superblocklinenumber.get(tid)).size()>0){
            				if (subblock.size()>0){
            					superblock.create(tid); 		            			  
            					superblock.add(tid,subblock,subblockxpos, subblockypos,subblockattribute, blockwidth, blockheight, blockdepth, 'x',0);	
            				}
            			}else {		     
            				superblock.add(tid,subblock,subblockxpos, subblockypos,subblockattribute,blockwidth, blockheight, blockdepth,'x', 0);
            			}
            		}
	
            		if (numatom>0){
            			indent =subblockxpos.get(0)+blockwidth-referencex+sizeofblank;
            			if (indent >= pagewidth && ii<nummolecule-1){
            				referencey=subblockypos.get(numatom-1)+(float)fontsize;
            				indent=0;
            			}else {			            		 
            				referencey=subblockypos.get(numatom-1);
            			}}	            	
	            		  
            		subblock.clear();
            		subblockxpos.clear();subblockypos.clear();subblockattribute.clear();
            	}else if (!molecule.equals("")){
            		if (dohyphenation && Header.dohyphenation){	            
            			
            			ParagraphFormatting paragraph = new ParagraphFormatting();
            			ParagraphBlock.newfirstline.put(tid, false);
            			paragraph.paragraphformatting(canvas,paragraphblock, pagewidth, molecule, tid, indent, attribute0, tf.get(Integer.parseInt(attribute0.substring(4,7))));
            			blockheight=(float)ParagraphBlock.line.size()*(float)fontsize;
            			blockwidth=ParagraphBlock.linelength.get(tid);
			            	  blockdepth=0.0f;
			            	  maxheight = Math.max(maxheight,(float)ParagraphBlock.line.get(tid).size()*(float)fontsize );
			            	  int numline=ParagraphBlock.line.get(tid).size();
			            	  for (i=0;i<=numline-1;i++){

			            		  if (!(ParagraphBlock.line.get(tid).get(i).equals(""))){
			            			  subblock.add(ParagraphBlock.line.get(tid).get(i));
			            			  subblockxpos.add(ParagraphBlock.xpos.get(tid).get(i)+referencex);
			            			  subblockypos.add(ParagraphBlock.ypos.get(tid).get(i)+referencey);   
			            			  subblockattribute.add(ParagraphBlock.attribute.get(tid).get(i));
			            			  ParagraphBlock.xpos.get(tid).set(i,ParagraphBlock.xpos.get(tid).get(i)+referencex);
			            			  ParagraphBlock.ypos.get(tid).set(i,ParagraphBlock.ypos.get(tid).get(i)+referencey);            		  
			     
			            			  if (i==0 && !ParagraphBlock.newfirstline.get(tid)){
			            				  synchronized(this){ superblock.add(tid,subblock,subblockxpos, subblockypos, subblockattribute, ParagraphBlock.linelength.get(tid), (float) fontsize, 0.0f, 'x',0);}
			            			  }else {
			            				  synchronized(this){
			            					  if (subblock.size()>0 && SuperBlock.blockatom.get(tid*1000+SuperBlock.superblocklinenumber.get(tid)).size()>0){
			            						  superblock.create(tid); 
			            						  superblock.add(tid,subblock,subblockxpos, subblockypos, subblockattribute, ParagraphBlock.linelength.get(tid), (float) fontsize, 0.0f, 'x',0);
			                			 } else if (subblock.size()>0) {
			                				 superblock.add(tid,subblock,subblockxpos, subblockypos, subblockattribute, ParagraphBlock.linelength.get(tid), (float) fontsize, 0.0f, 'x',0);
			                			 }
			            				  }
			            			  }			
			            			  subblock.clear();
			            			  subblockxpos.clear();subblockypos.clear();subblockattribute.clear();
			            		  }
			            	  }	
			            	  if (numline > 0){indent=ParagraphBlock.xpos.get(tid).get(numline-1)+ParagraphBlock.xpos.get(tid).get(numline-1)-referencex;
			            	  if (indent >= pagewidth && ii<nummolecule-1){
			            		  referencey=ParagraphBlock.ypos.get(tid).get(numline-1)+(float)fontsize;
			            		  indent=0;
			            	  }else {			            		 
			            		  referencey=ParagraphBlock.ypos.get(tid).get(numline-1);
			            	  }};
            		} 
            		else {                    	  

            			ParagraphFormatting2 paragraph2 = new ParagraphFormatting2();	
            			paragraph2.paragraphformatting2(canvas, paragraphblock, pagewidth, molecule, tid, indent, attribute0, tf.get(Integer.parseInt(attribute0.substring(4,7))));
            			blockheight=(float)ParagraphBlock.line.get(tid).size()*(float)fontsize;
            			blockwidth=ParagraphBlock.linelength.get(tid);
            			blockdepth=0.0f;

            			maxheight = Math.max(maxheight,(float)ParagraphBlock.line.get(tid).size()*(float)fontsize );
            			int numline=ParagraphBlock.line.get(tid).size();
            			for (i=0;i<=numline-1;i++){
            				if (!(ParagraphBlock.line.get(tid).get(i).equals(""))){
            					subblock.add(ParagraphBlock.line.get(tid).get(i));
            					subblockxpos.add(ParagraphBlock.xpos.get(tid).get(i)+referencex);
            					subblockypos.add(ParagraphBlock.ypos.get(tid).get(i)+referencey);   
            					subblockattribute.add(ParagraphBlock.attribute.get(tid).get(i));
            					ParagraphBlock.xpos.get(tid).set(i,ParagraphBlock.xpos.get(tid).get(i)+referencex);				            		 
            					ParagraphBlock.ypos.get(tid).set(i,ParagraphBlock.ypos.get(tid).get(i)+referencey);
				            		  
            					if (i==0 && !ParagraphBlock.newfirstline.get(tid)){
            						synchronized(this){superblock.add(tid,subblock,subblockxpos, subblockypos, subblockattribute, ParagraphBlock.tlinelength.get(tid).get(i), (float) fontsize, 0.0f,'x', 0);}
            					}else {
            						synchronized(this){				                 			 
            							if (subblock.size()>0 && SuperBlock.blockatom.get(tid*1000+SuperBlock.superblocklinenumber.get(tid)).size()>0){
            								superblock.create(tid); 
            								superblock.add(tid,subblock,subblockxpos, subblockypos, subblockattribute, ParagraphBlock.linelength.get(tid), (float) fontsize, 0.0f, 'x',0);
            							} else if (subblock.size()>0) {
            								superblock.add(tid,subblock,subblockxpos, subblockypos, subblockattribute, ParagraphBlock.linelength.get(tid), (float) fontsize, 0.0f, 'x',0);
            							}
            						}
            					}			            		  
				                 	  
            					subblock.clear();
            					subblockxpos.clear();subblockypos.clear();subblockattribute.clear();
            				}
            			}
            			if (numline > 0) {indent=ParagraphBlock.xpos.get(tid).get(numline-1)+ParagraphBlock.width.get(tid).get(numline-1)-referencex;
            			if (indent >= pagewidth && ii<nummolecule-1){
            				referencey=ParagraphBlock.ypos.get(tid).get(numline-1)+(float)fontsize;
            				indent=0;
            				newline=true;
				 
            			}else {			            		
            				referencey=ParagraphBlock.ypos.get(tid).get(numline-1);
            				newline=false;
            			}};
            		}                     
            	}}
            thisypos.put(tid, referencey+maxdepth+Header.linegap); 
            error.put(tid, false);
            errormessage.put(tid, "");
	    };                 
	}                 
	          
	    
	    