/*
 * SOURCE:  memory.h
 * PROJECT: EasyTeX
 *
 * PURPOSE: function prototypes and defines
 *
 * UPDATES: 11/16/1991 - major rewrite
 *
 * (c)M.Schollmeyer
 */
#ifndef MEMORY_H
#define MEMORY_H

    /* The following manifest constant declares how many bytes
       make a paragraph in DOS memory */
#define BYTES_PER_PARAGRAPH 16

#define NULLPTR 0xffffffffL

    /* frame flags */
#define SMALLFRAME 0x00
#define LARGEFRAME 0x01
#define FREEFRAME  0x00
#define ALLOCFRAME 0x02

        /* memory header */
struct MemoryHeader {
unsigned long size;
unsigned char _huge *base;
unsigned long _huge *desc;
unsigned char _huge *endlines;
unsigned int numlines;
};

#define MIN_MEM_SIZE ( 64L * 1024L ) /* minimum buffer size */


unsigned long m_init( void );
int m_cleanup( void );
int m_getline( unsigned int, unsigned char _huge * );
void m_getcurrentline(void );
BOOL m_putcurrentline( void );
BOOL m_putline( unsigned char *, unsigned int, int );
BOOL m_insertline( unsigned int );
void m_deleteline( unsigned int, unsigned int );
BOOL m_load( int );
BOOL m_loadvirtual( unsigned );
int m_save( int );
int m_savevirtual( void );
int m_pack( int, int );
unsigned int m_framesize( unsigned );

void m_beginundogroup( void );
void m_endundogroup( void );

BOOL m_isrestoreable( void );
BOOL m_isredoable( void );
void m_undo( void );
void m_redo( void );

int m_putmsg( unsigned int, char *, ... );
int m_putxmsg( unsigned int, int, char *, ... );

unsigned long MemFree( void );
void *AllocHeap( unsigned int );
void *HeapStrDup( char * );

/* Stack Functions */
void FreeStack( void * );          /* FreeStack( stackpos ); */
void *PopStack( void * );          /* newpos = FreeStack( oldpos ); */
void *PushStack( void *, UBYTE *, unsigned );
                                   /* newpos = PushStack( oldpos, data ); */

struct MarkRegion *m_getmr( void );

#endif
