/*
 * LaTeD Version 1.1
 * (c) Gene Ressler 1993, 94, 97
 *   de8827@trotter.usma.edu
 *
 * LaTeD is a graphical editor for drawings in the LaTeX "picture" 
 * environment.  It runs under MSDOS or in a Windows DOS box.  The
 * distribution includes full sources, including LaTeX source for 
 * its documentation.
 *
 * No warranty of this software is expressed or implied by the author.
 *
 * Copy and use this program freely for any purpose except for sale
 * of the program (including the source code) itself.  That is, 
 * no one can copy this program for the purpose of providing it to 
 * another person in exchange for money or other compensation, even 
 * if this program is only part of the exchange.
 *
 * All copies of computer source code in this distribution, whether
 * copies in whole or in part, must have this notice attached.
 */

/* WALK.C --- Walk the window tree to
   see where an event occurred. */

#include <stdlib.h>
#include <assert.h>
#include "window.h"
#include "wintern.h"

#define FORCE_SI_DI_PUSH  _SI=_DI

static x, y, mask;
static WINDOW event_window;
static WINDOW ptr_window;
static unsigned start_sp;

#pragma argsused
static void pascal near finish(w)
WINDOW w;
{
  FORCE_SI_DI_PUSH;
  _SP = start_sp;
}

static void pascal near mew(WINDOW w)
{
  if (w_status_p(w, wsVISIBLE) &&
      x >= w->x - w->border_width &&
      y >= w->y - w->border_width &&
      x < w->x + w->width + w->border_width &&
      y < w->y + w->height + w->border_width) {

    if (mask & w->event_mask)
      event_window = w;

    if (w->kids != NULL) {
      WINDOW k = w->kids;
      do {
        mew(k);
      } while ((k = k->next) != w->kids);
    }

    ptr_window = w;
#   pragma warn -pro
    finish();
#   pragma warn .pro
  }
}

static void pascal near start(WINDOW root)
{
  FORCE_SI_DI_PUSH;
  start_sp = _SP;
  mew(root);
}

static WINDOW root_stk[MAX_N_ROOTS];
static int rsp;

/* Return the window where a mouse event occurred.
   Also the visible window where the pointer is. */
void get_mouse_event_window(int event_x, int event_y,
			    EVENT_TYPE type,
			    WINDOW *event_window_rtn,
			    WINDOW *ptr_window_rtn)
{
  int i;
  WINDOW r;

  x = event_x;
  y = event_y;
  mask = bit(type);
  if (type == eMOUSE_MOTION)
    mask |= bit(eENTRY)|bit(eDEPARTURE);

  if (rsp == 0) {
    event_window = NULL;
    start(ptr_window = root_window);
  }
  else {
    for (i = rsp - 1; i >= 0; --i) {
      ptr_window = r = root_stk[i];
      event_window = w_status_p(r, wsSTOP_ROOT) ? r : NULL;
      start(r);
      if (event_window != NULL) 
	break;
    } 
  }
  *ptr_window_rtn = ptr_window;
  *event_window_rtn = event_window;
}

/* Install a temporary root window for events. */
void push_root_window(WINDOW w, int stop_p)
{
  assert(rsp < MAX_N_ROOTS);
  set_bit(w->status_mask, wsSTOP_ROOT, stop_p || rsp == 0);
  root_stk[rsp++] = w;
  update_ptr_window();
}

/* Uninstall temporary root. */
void pop_root_window(void)
{
  assert(rsp > 0);
  --rsp;
  update_ptr_window();
}

/* If root stack is active and a root is invisible,
   change it to an ancestor that is visible. */
void check_roots_visible(void)
{
  int i;

  assert(w_status_p(root_window, wsVISIBLE));
  for (i = 0; i < rsp; ++i)
    while (!w_status_p(root_stk[i], wsVISIBLE))
      root_stk[i] = root_stk[i]->parent;
}