/* chmod.c -- change file permissions.

   Copyright (C) 1994, 1995 Ralph Schleicher  */

/* This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <io.h>
#include "ansidecl.h"
#include "symlink.h"


int
DEFUN (symlink_chmod, (name, mode),
const char *name AND
int mode)
{
  char buffer[_MAX_PATH];
  int length;

  length = _resolvlink (name, buffer, _MAX_PATH);
  if (length >= 0)
    return (chmod (buffer, mode));

  return (-1);
}
