---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, lignes, fin de ligne, saut de ligne,
              paragraphes, fin de paragraphe
---

# Comment insérer un retour chariot ?

Un [retour chariot](wpfr:Retour_chariot) (fin de ligne) dans votre code source
n'est pas directement relié au formatage final de votre document. 
Il y a quelques petites choses à savoir :

- **un** retour chariot est considéré comme une espace ;
- **deux retours chariot consécutifs ou plus** marquent la fin du paragraphe 
  en cours et entraînent donc un nouveau paragraphe avec un alinéa. 
  Sauter plus d'une ligne n'a aucun effet supplémentaire. 

Quelques commandes permettent d'obtenir des effets proches :
- `\\` ou `\newline` peuvent forcer un passage à la ligne mais, dans ce cas, 
  la première ligne du nouveau paragraphe n'aura pas d'alinéa ;
- `\\*` empêche un saut de page après le saut de ligne demandé ; 
- `\par` permet de commencer un nouveau paragraphe en laissant 
  une espace verticale plus importante. Ce nouveau paragraphe commence 
  avec un alinéa. Vous pouvez consulter la section [](../paragraphes/start) 
  pour en savoir plus.

Voici un exemple illustrant ces différents points :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  
\begin{document}
Ce texte contient des retours à la ligne
simples mais aussi multiples (trois consécutifs dans le cas présent).


Et ils n'ont donc pas la même fonction. \\ De même, les différentes 
commandes de retour à la ligne donnent des résultats distincts. \par Elles
correspondent à différents besoins.
\end{document}
```

Notez que la commande `\\` peut prendre comme paramètre une longueur `\\[6ex]`
pour augmenter localement un interligne.