#include <stdio.h>

/*	Translation File for greek ISO characters to TeX input */

void process_tex_file();

main(argc,argv)
	int argc;
	char **argv;
{
	FILE *f;
	int i;
	char *InFileN;
	char *OutFileN;
	FILE *InFile;
	FILE *OutFile;

	if (argc >= 2){
		InFileN=argv[1];
		if( (InFile = fopen(InFileN,"r")) == NULL){
			extern int errno, sys_nerr;
			extern char *sys_errlist[];

			fprintf(stderr, "%s: can't open file %s (%s)\n",
			argv[0],InFileN,
			(errno > 0 && errno < sys_nerr) ? sys_errlist[errno] : "Unkown error" );
			exit( 1 );
		}
	}
	else
		InFile=stdin;
	if (argc == 3){
		OutFileN = argv[2];
		if( (OutFile = fopen(OutFileN,"w")) == NULL){
			extern int errno, sys_nerr;
			extern char *sys_errlist[];

			fprintf(stderr, "%s: can't open file %s (%s)\n",
			argv[0],OutFileN,
			(errno > 0 && errno < sys_nerr) ? sys_errlist[errno] : "Unkown error" );
			exit( 1 );
		}
	} else
		OutFile = stdout;
	
	process_tex_file(InFile,OutFile);
	exit(0);
}


void process_tex_file(in,out)
	FILE *in;
	FILE *out;
{
	int ch;


	fprintf(out,
	  "%%	ISO (IBM) greek ascii -> to greekTeX automatic translation\n");
	fprintf(out,"%%         Converter by K J Dryllerakis\n");
	while((ch = fgetc(in)) != EOF){
		switch (ch){
			case 182: fprintf(out,"'A"); break;
			case 184: fprintf(out,"'E"); break;
			case 185: fprintf(out,"'H"); break;
			case 186: fprintf(out,"'I"); break;
			case 188: fprintf(out,"'O"); break;
			case 190: fprintf(out,"'Y"); break;
			case 191: fprintf(out,"'W"); break;
			case 192: fprintf(out,"'i"); break;
			case 193: fprintf(out,"A"); break;	/* Capitals */
			case 194: fprintf(out,"B"); break;
			case 195: fprintf(out,"G"); break;
			case 196: fprintf(out,"D"); break;
			case 197: fprintf(out,"E"); break;
			case 198: fprintf(out,"Z"); break;
			case 199: fprintf(out,"H"); break;
			case 200: fprintf(out,"J"); break;
			case 201: fprintf(out,"I"); break;
			case 202: fprintf(out,"K"); break;
			case 203: fprintf(out,"L"); break;
			case 204: fprintf(out,"M"); break;
			case 205: fprintf(out,"N"); break;
			case 206: fprintf(out,"X"); break;
			case 207: fprintf(out,"O"); break;
			case 208: fprintf(out,"P"); break;
			case 209: fprintf(out,"R"); break;
			case 211: fprintf(out,"S"); break;
			case 212: fprintf(out,"T"); break;
			case 213: fprintf(out,"U"); break;
			case 214: fprintf(out,"F"); break;
			case 215: fprintf(out,"Q"); break;
			case 216: fprintf(out,"Y"); break;
			case 217: fprintf(out,"W"); break;
			case 218: fprintf(out,"\"I"); break;	/* " */
			case 219: fprintf(out,"\"Y"); break;
			case 220: fprintf(out,"'a"); break;	/* lower +' */
			case 221: fprintf(out,"'e"); break;
			case 222: fprintf(out,"'h"); break;
			case 223: fprintf(out,"'i"); break;
			case 224: fprintf(out,"\"'u"); break;
			case 225: fprintf(out,"a"); break;	/* lower */
			case 226: fprintf(out,"b"); break;
			case 227: fprintf(out,"g"); break;
			case 228: fprintf(out,"d"); break;
			case 229: fprintf(out,"e"); break;
			case 230: fprintf(out,"z"); break;
			case 231: fprintf(out,"h"); break;
			case 232: fprintf(out,"j"); break;
			case 233: fprintf(out,"i"); break;
			case 234: fprintf(out,"k"); break;
			case 235: fprintf(out,"l"); break;
			case 236: fprintf(out,"m"); break;
			case 237: fprintf(out,"n"); break;
			case 238: fprintf(out,"x"); break;
			case 239: fprintf(out,"o"); break;
			case 240: fprintf(out,"p"); break;
			case 241: fprintf(out,"r"); break;
			case 242: fprintf(out,"c"); break;
			case 243: fprintf(out,"s"); break;
			case 244: fprintf(out,"t"); break;
			case 245: fprintf(out,"u"); break;
			case 246: fprintf(out,"f"); break;
			case 247: fprintf(out,"q"); break;
			case 248: fprintf(out,"y"); break;
			case 249: fprintf(out,"w"); break;
			case 250: fprintf(out,"\"i"); break;
			case 251: fprintf(out,"\"u"); break;
			case 252: fprintf(out,"'o"); break;
			case 253: fprintf(out,"'u"); break;
			case 254: fprintf(out,"'w"); break;
			default:
				if (ch <= 128 ){
					fprintf(out,"%c",ch);
				}
				break;
		}
	}
}

