![Banner](documentation/Ysabeau_Banner.png)

# The Ysabeau Typeface Project (formerly «Eau de Garamond»)

Ysabeau is a free type family developed by Christian Thalmann ([Catharsis Fonts][1]). It combines the time-honored and supremely readable letterforms of the Garamond legacy with the clean crispness of a low-contrast sans serif, rendering it well suited for body copy as well as display. It is open source, and all its working files (in [Glyphs][2] format) are available from this repository. If you wish to work with Ysabeau in a different font editor (which I wouldn't recommend), I can provide you with UFO versions of those files instead.

Any feedback, bug reports, test results, and suggestions for additions are very welcome. You can contact me using the [Ysabeau issue tracker][4]. 

If you like Ysabeau, please help spread the word via the social media of your choice. You might also be interested in my other typefaces on [MyFonts][1] and in my other free type family [Cormorant][3].

### Styles

Apart from the default cut of the Ysabeau typeface, the following spin-off fonts are available for download:

* Office: Promotes the OpenType features SS02, LNUM, and TNUM to default. This suppresses the contextual use of long and superlong Q, turns the slanted hyphens horizontal, and replaces the old-style figures with tabular lining figures.
* Infant: Promotes SS01, loclBGR, and LNUM to default. This activates single-storey designs for a and g, a script y, a tailed l, Bulgarian Cyrillic forms, and proportional lining figures.
* SC: Promotes SMCP to default. This activates smallcaps.

The spin-off fonts are meant for convenience in environments without reliable OpenType support. In professional settings, it is recommended to use the base fonts and to activate the desired OpenType features.

### Installation

If you wish to use the Ysabeau type family on your computer, simply download the "Ysabeau_Install" ZIP file from the [latest release][5], unpack it, and install the TrueType font files (.ttf) as appropriate for your operating system.

If you wish to use the Ysabeau type family on your website, you will be able to obtain it from the [Google Fonts][12] service once it is finished.

### License
 
The Ysabeau typeface and all its associated font files are free software under the [SIL Open Font License][10]. Essentially, this gives you the right to download, use, and redistribute the fonts as you like, provided that 

1. you retain my copyright notices;
2. you do not redistribute this software without this license information; and 
3. you do not redistribute the fonts by themselves for a fee (though you are allowed to sell them as part of a bundle containing other items.)

### Acknowledgements
 
Ysabeau has been conceived, drawn, spaced, kerned, programmed, interpolated, and produced by myself (Christian Thalmann, [Catharsis Fonts][1]). I worked with [Glyphs][2], which I consider the world's best font editing software. It's not free, but it's worth every penny ten times over; I cannot recommend it enough. I used the RMX Harmonizer plug-in to ensure curve quality. Andreas Stötzner consulted me on the Latin, Alexei Vanyashin on the Cyrillic, and Irene Vlachou on the Greek, all of which significantly improved the typeface.
 
While this project was heavily inspired by [Claude Garamont][6]'s immortal legacy, I did not use any specific font as a starting point or direct reference for my designs. Most glyphs were drawn from scratch, using the source files for my previous Garamond-flavored typeface [Cormorant][3] as a starting point to save time on defining kerning classes and OpenType coding. When I needed guidance regarding the Garamond solution on a specific character, I usually looked at the free typeface [«EB Garamond» by Georg Duffner][13].
 
I am very grateful to the creative souls on the [TypeDrawers][7] forum, the [Typografie.info][11] forum, and the (late?) [Typophile][8] forum for teaching me all I know about type design in the first place, and for providing me with a large amount of excellent feedback on Ysabeau. This goes in particular for Jasper de Waard, Pablo Impallari, and Thorsten Naab, who were particularly generous with their help. Likewise, my gratitude goes to the tireless folks at [Glyphs][2] — in particular Rainer Erich Scheichelbauer (Mekka Blue, [Schriftlabor][9]) and Georg Seifert — for the creation and support of their magnificent engine. 

[1]: https://www.myfonts.com/foundry/Catharsis_Fonts
[2]: https://glyphsapp.com
[3]: https://github.com/CatharsisFonts/Cormorant/
[4]: https://github.com/CatharsisFonts/Ysabeau/issues
[5]: https://github.com/CatharsisFonts/Ysabeau/releases/latest
[6]: https://en.wikipedia.org/wiki/Claude_Garamond
[7]: https://typedrawers.com
[8]: https://typophile.com
[9]: https://schriftlabor.at
[10]: https://scripts.sil.org/OFL
[11]: https://typografie.info
[12]: https://fonts.google.com
[13]: http://www.georgduffner.at/ebgaramond/
